/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.namingserver.controller;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.seata.common.metadata.namingserver.MetaResponse;
import org.apache.seata.common.metadata.namingserver.NamingServerNode;
import org.apache.seata.common.result.Result;
import org.apache.seata.common.result.SingleResult;
import org.apache.seata.namingserver.entity.vo.NamespaceVO;
import org.apache.seata.namingserver.entity.vo.monitor.ClusterVO;
import org.apache.seata.namingserver.entity.vo.monitor.WatcherVO;
import org.apache.seata.namingserver.listener.Watcher;
import org.apache.seata.namingserver.manager.ClusterWatcherManager;
import org.apache.seata.namingserver.manager.NamingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/naming/v1", "/api/v1/naming"})
public class NamingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamingController.class);
    @Resource
    private NamingManager namingManager;
    @Resource
    private ClusterWatcherManager clusterWatcherManager;

    @PostMapping(value={"/register"})
    public Result<String> registerInstance(@RequestParam String namespace, @RequestParam String clusterName, @RequestParam String unit, @RequestBody NamingServerNode registerBody) {
        Result result = new Result();
        boolean isSuccess = this.namingManager.registerInstance(registerBody, namespace, clusterName, unit);
        if (isSuccess) {
            result.setMessage("node has registered successfully!");
        } else {
            result.setCode("500");
            result.setMessage("node registered unsuccessfully!");
        }
        return result;
    }

    @PostMapping(value={"/batchRegister"})
    public Result<String> batchRegisterInstance(@RequestParam String namespace, @RequestParam String clusterName, @RequestBody List<NamingServerNode> nodes) {
        Result result = new Result();
        boolean isSuccess = this.namingManager.registerInstances(nodes, namespace, clusterName);
        if (isSuccess) {
            result.setMessage("node has registered successfully!");
        } else {
            result.setCode("500");
            result.setMessage("node registered unsuccessfully!");
        }
        return result;
    }

    @PostMapping(value={"/unregister"})
    public Result<String> unregisterInstance(@RequestParam String namespace, @RequestParam String clusterName, @RequestParam String unit, @RequestBody NamingServerNode registerBody) {
        Result result = new Result();
        boolean isSuccess = this.namingManager.unregisterInstance(namespace, clusterName, unit, registerBody);
        if (isSuccess) {
            result.setMessage("node has unregistered successfully!");
        } else {
            result.setCode("500");
            result.setMessage("node unregistered unsuccessfully!");
        }
        return result;
    }

    @GetMapping(value={"/clusters"})
    public List<ClusterVO> monitorCluster(String namespace) {
        return this.namingManager.monitorCluster(namespace);
    }

    @GetMapping(value={"/discovery"})
    public MetaResponse discovery(@RequestParam String vGroup, @RequestParam String namespace) {
        return new MetaResponse(this.namingManager.getClusterListByVgroup(vGroup, namespace), this.clusterWatcherManager.getTermByvGroup(vGroup));
    }

    @PostMapping(value={"/addGroup"})
    public Result<String> addGroup(@RequestParam String namespace, @RequestParam String clusterName, String unitName, @RequestParam String vGroup) {
        Result addGroupResult = this.namingManager.createGroup(namespace, vGroup, clusterName, unitName);
        if (!addGroupResult.isSuccess()) {
            return addGroupResult;
        }
        return new Result("200", "change vGroup " + vGroup + "to cluster " + clusterName + " successfully!");
    }

    @PostMapping(value={"/changeGroup"})
    public Result<String> changeGroup(@RequestParam String namespace, @RequestParam String clusterName, @RequestParam String unitName, @RequestParam String vGroup) {
        Result addGroupResult = this.namingManager.changeGroup(namespace, vGroup, clusterName, unitName);
        if (!addGroupResult.isSuccess()) {
            return addGroupResult;
        }
        return new Result("200", "change vGroup " + vGroup + "to cluster " + clusterName + " successfully!");
    }

    @GetMapping(value={"/namespace"})
    public SingleResult<Map<String, NamespaceVO>> namespaces() {
        return this.namingManager.namespace();
    }

    @PostMapping(value={"/watch"})
    public void watch(@RequestParam String clientTerm, @RequestParam String vGroup, @RequestParam String timeout, HttpServletRequest request) {
        AsyncContext context = request.startAsync();
        context.setTimeout(0L);
        Watcher watcher = new Watcher(vGroup, (Object)context, Integer.parseInt(timeout), Long.parseLong(clientTerm), request.getRemoteAddr());
        this.clusterWatcherManager.registryWatcher(watcher);
    }

    @GetMapping(value={"/watchList"})
    public List<WatcherVO> getWatchList() {
        List watchVGroupList = this.clusterWatcherManager.getWatchVGroupList();
        return watchVGroupList.stream().map(vgroup -> new WatcherVO(vgroup, this.clusterWatcherManager.getWatcherIpList(vgroup))).collect(Collectors.toList());
    }
}

