/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractByteHasher;
import com.google.common.hash.AbstractStreamingHashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

final class MessageDigestHashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final MessageDigest prototype;
    private final int bytes;
    private final boolean supportsClone;
    private final String toString;

    MessageDigestHashFunction(String algorithmName, String toString2) {
        this.prototype = MessageDigestHashFunction.getMessageDigest(algorithmName);
        this.bytes = this.prototype.getDigestLength();
        this.toString = Preconditions.checkNotNull(toString2);
        this.supportsClone = this.supportsClone();
    }

    MessageDigestHashFunction(String algorithmName, int bytes, String toString2) {
        this.toString = Preconditions.checkNotNull(toString2);
        this.prototype = MessageDigestHashFunction.getMessageDigest(algorithmName);
        int maxLength2 = this.prototype.getDigestLength();
        Preconditions.checkArgument(bytes >= 4 && bytes <= maxLength2, "bytes (%s) must be >= 4 and < %s", bytes, maxLength2);
        this.bytes = bytes;
        this.supportsClone = this.supportsClone();
    }

    private boolean supportsClone() {
        try {
            this.prototype.clone();
            return true;
        }
        catch (CloneNotSupportedException e) {
            return false;
        }
    }

    @Override
    public int bits() {
        return this.bytes * 8;
    }

    public String toString() {
        return this.toString;
    }

    private static MessageDigest getMessageDigest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Hasher newHasher() {
        if (this.supportsClone) {
            try {
                return new MessageDigestHasher((MessageDigest)this.prototype.clone(), this.bytes);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return new MessageDigestHasher(MessageDigestHashFunction.getMessageDigest(this.prototype.getAlgorithm()), this.bytes);
    }

    Object writeReplace() {
        return new SerializedForm(this.prototype.getAlgorithm(), this.bytes, this.toString);
    }

    private static final class MessageDigestHasher
    extends AbstractByteHasher {
        private final MessageDigest digest;
        private final int bytes;
        private boolean done;

        private MessageDigestHasher(MessageDigest digest2, int bytes) {
            this.digest = digest2;
            this.bytes = bytes;
        }

        @Override
        protected void update(byte b2) {
            this.checkNotDone();
            this.digest.update(b2);
        }

        @Override
        protected void update(byte[] b2) {
            this.checkNotDone();
            this.digest.update(b2);
        }

        @Override
        protected void update(byte[] b2, int off, int len2) {
            this.checkNotDone();
            this.digest.update(b2, off, len2);
        }

        private void checkNotDone() {
            Preconditions.checkState(!this.done, "Cannot use Hasher after calling #hash() on it");
        }

        @Override
        public HashCode hash() {
            this.done = true;
            return this.bytes == this.digest.getDigestLength() ? HashCode.fromBytesNoCopy(this.digest.digest()) : HashCode.fromBytesNoCopy(Arrays.copyOf(this.digest.digest(), this.bytes));
        }
    }

    private static final class SerializedForm
    implements Serializable {
        private final String algorithmName;
        private final int bytes;
        private final String toString;
        private static final long serialVersionUID = 0L;

        private SerializedForm(String algorithmName, int bytes, String toString2) {
            this.algorithmName = algorithmName;
            this.bytes = bytes;
            this.toString = toString2;
        }

        private Object readResolve() {
            return new MessageDigestHashFunction(this.algorithmName, this.bytes, this.toString);
        }
    }
}

