/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.SynthesizedAnnotation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

final class SynthesizedMergedAnnotationInvocationHandler<A extends Annotation>
implements InvocationHandler {
    private final MergedAnnotation<?> annotation;
    private final Class<A> type;
    private final AttributeMethods attributes;
    @Nullable
    private volatile Integer hashCode;

    private SynthesizedMergedAnnotationInvocationHandler(MergedAnnotation<A> annotation, Class<A> type) {
        Assert.notNull(annotation, "MergedAnnotation must not be null");
        Assert.notNull(type, "Type must not be null");
        Assert.isTrue(type.isAnnotation(), "Type must be an annotation");
        this.annotation = annotation;
        this.type = type;
        this.attributes = AttributeMethods.forAnnotationType(type);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (ReflectionUtils.isEqualsMethod(method)) {
            return this.annotationEquals(args[0]);
        }
        if (ReflectionUtils.isHashCodeMethod(method)) {
            return this.annotationHashCode();
        }
        if (ReflectionUtils.isToStringMethod(method)) {
            return this.annotation.toString();
        }
        if (this.isAnnotationTypeMethod(method)) {
            return this.type;
        }
        if (this.attributes.indexOf(method.getName()) != -1) {
            return this.getAttributeValue(method);
        }
        throw new AnnotationConfigurationException(String.format("Method [%s] is unsupported for synthesized annotation type [%s]", method, this.type));
    }

    private boolean isAnnotationTypeMethod(Method method) {
        return method.getName().equals("annotationType") && method.getParameterCount() == 0;
    }

    private boolean annotationEquals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.type.isInstance(other)) {
            return false;
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            Object otherValue;
            Method attribute = this.attributes.get(i);
            Object thisValue = this.getAttributeValue(attribute);
            if (ObjectUtils.nullSafeEquals(thisValue, otherValue = ReflectionUtils.invokeMethod(attribute, other))) continue;
            return false;
        }
        return true;
    }

    private int annotationHashCode() {
        Integer hashCode2 = this.hashCode;
        if (hashCode2 == null) {
            this.hashCode = hashCode2 = this.computeHashCode();
        }
        return hashCode2;
    }

    private Integer computeHashCode() {
        int hashCode2 = 0;
        for (int i = 0; i < this.attributes.size(); ++i) {
            Method attribute = this.attributes.get(i);
            Object value2 = this.getAttributeValue(attribute);
            hashCode2 += 127 * attribute.getName().hashCode() ^ this.getValueHashCode(value2);
        }
        return hashCode2;
    }

    private int getValueHashCode(Object value2) {
        if (value2 instanceof boolean[]) {
            return Arrays.hashCode((boolean[])value2);
        }
        if (value2 instanceof byte[]) {
            return Arrays.hashCode((byte[])value2);
        }
        if (value2 instanceof char[]) {
            return Arrays.hashCode((char[])value2);
        }
        if (value2 instanceof double[]) {
            return Arrays.hashCode((double[])value2);
        }
        if (value2 instanceof float[]) {
            return Arrays.hashCode((float[])value2);
        }
        if (value2 instanceof int[]) {
            return Arrays.hashCode((int[])value2);
        }
        if (value2 instanceof long[]) {
            return Arrays.hashCode((long[])value2);
        }
        if (value2 instanceof short[]) {
            return Arrays.hashCode((short[])value2);
        }
        if (value2 instanceof Object[]) {
            return Arrays.hashCode((Object[])value2);
        }
        return value2.hashCode();
    }

    private Object getAttributeValue(Method method) {
        String name = method.getName();
        Class<?> type = ClassUtils.resolvePrimitiveIfNecessary(method.getReturnType());
        return this.annotation.getValue(name, type).orElseThrow(() -> new NoSuchElementException("No value found for attribute named '" + name + "' in merged annotation " + this.annotation.getType().getName()));
    }

    static <A extends Annotation> A createProxy(MergedAnnotation<A> annotation, Class<A> type) {
        Class[] classArray;
        ClassLoader classLoader = type.getClassLoader();
        SynthesizedMergedAnnotationInvocationHandler<A> handler = new SynthesizedMergedAnnotationInvocationHandler<A>(annotation, type);
        if (SynthesizedMergedAnnotationInvocationHandler.isVisible(classLoader, SynthesizedAnnotation.class)) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = type;
            classArray = classArray2;
            classArray2[1] = SynthesizedAnnotation.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = type;
        }
        Class[] interfaces = classArray;
        return (A)((Annotation)Proxy.newProxyInstance(classLoader, interfaces, handler));
    }

    private static boolean isVisible(ClassLoader classLoader, Class<?> interfaceClass) {
        try {
            return Class.forName(interfaceClass.getName(), false, classLoader) == interfaceClass;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }
}

