/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.region;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class MigrateRegionStatement
extends Statement
implements IConfigStatement {
    private final int regionId;
    private final int fromId;
    private final int toId;

    public MigrateRegionStatement(int regionId, int fromId, int toId) {
        this.regionId = regionId;
        this.fromId = fromId;
        this.toId = toId;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public int getFromId() {
        return this.fromId;
    }

    public int getToId() {
        return this.toId;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        return AuthorityChecker.checkSuperUserOrMaintain(userName);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitMigrateRegion(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    @Override
    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }
}

