/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path.fa.dfa.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.path.fa.IFAState;

public class Closure {
    private final byte[] bitmap;
    private final List<IFAState> states = new ArrayList<IFAState>();

    public Closure(int capacity) {
        this.bitmap = new byte[capacity];
    }

    public void addState(IFAState state) {
        if (this.bitmap[state.getIndex()] == 0) {
            this.bitmap[state.getIndex()] = 1;
            this.states.add(state);
        }
    }

    public List<IFAState> getStates() {
        return this.states;
    }

    public boolean isFinal() {
        boolean res = false;
        for (IFAState state : this.states) {
            res |= state.isFinal();
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Closure closure = (Closure)o;
        return Arrays.equals(this.bitmap, closure.bitmap);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bitmap);
    }
}

