/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view.viewExpression.unary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpressionType;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.UnaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class RegularViewExpression
extends UnaryViewExpression {
    private final String patternString;
    private final Pattern pattern;
    private final boolean isNot;

    public RegularViewExpression(ViewExpression expression, String patternString, boolean isNot) {
        super(expression);
        this.patternString = patternString;
        this.isNot = isNot;
        this.pattern = Pattern.compile(patternString);
    }

    public RegularViewExpression(ViewExpression expression, String patternString, Pattern pattern, boolean isNot) {
        super(expression);
        this.patternString = patternString;
        this.pattern = pattern;
        this.isNot = isNot;
    }

    public RegularViewExpression(ByteBuffer byteBuffer) {
        super(ViewExpression.deserialize(byteBuffer));
        this.patternString = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.isNot = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        this.pattern = Pattern.compile((String)Validate.notNull((Object)this.patternString));
    }

    public RegularViewExpression(InputStream inputStream) {
        super(ViewExpression.deserialize(inputStream));
        try {
            this.patternString = ReadWriteIOUtils.readString((InputStream)inputStream);
            this.isNot = ReadWriteIOUtils.readBool((InputStream)inputStream);
            this.pattern = Pattern.compile((String)Validate.notNull((Object)this.patternString));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R, C> R accept(ViewExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitRegularExpression(this, context);
    }

    @Override
    public ViewExpressionType getExpressionType() {
        return ViewExpressionType.REGEXP;
    }

    @Override
    public String toString(boolean isRoot) {
        return (this.isNot ? "NOT " : "") + "REGULAR(" + this.expression.toString() + ", " + this.patternString + ")";
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.patternString, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isNot, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(OutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.patternString, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isNot, (OutputStream)stream);
    }

    public String getPatternString() {
        return this.patternString;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isNot() {
        return this.isNot;
    }
}

