/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.service;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.load.cache.LoadCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsService.class);
    public static final long STATISTICS_UPDATE_INTERVAL = ConfigNodeDescriptor.getInstance().getConf().getHeartbeatIntervalInMs();
    private final LoadCache loadCache;
    private final Object statisticsScheduleMonitor = new Object();
    private Future<?> currentLoadStatisticsFuture;
    private final ScheduledExecutorService loadStatisticsExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.CONFIG_NODE_LOAD_STATISTIC.getName());

    public StatisticsService(LoadCache loadCache) {
        this.loadCache = loadCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoadStatisticsService() {
        Object object = this.statisticsScheduleMonitor;
        synchronized (object) {
            if (this.currentLoadStatisticsFuture == null) {
                this.currentLoadStatisticsFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.loadStatisticsExecutor, this::updateLoadStatistics, (long)0L, (long)STATISTICS_UPDATE_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
                LOGGER.info("LoadStatistics service is started successfully.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoadStatisticsService() {
        Object object = this.statisticsScheduleMonitor;
        synchronized (object) {
            if (this.currentLoadStatisticsFuture != null) {
                this.currentLoadStatisticsFuture.cancel(false);
                this.currentLoadStatisticsFuture = null;
                LOGGER.info("LoadStatistics service is stopped successfully.");
            }
        }
    }

    private void updateLoadStatistics() {
        this.loadCache.updateNodeStatistics(false);
        this.loadCache.updateRegionGroupStatistics();
        this.loadCache.updateConsensusGroupStatistics();
    }
}

