/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.schema;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.PipeWritePlanEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaSerializableEventType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeSchemaRegionWritePlanEvent
extends PipeWritePlanEvent {
    private PlanNode planNode;

    public PipeSchemaRegionWritePlanEvent() {
        this(null, false);
    }

    public PipeSchemaRegionWritePlanEvent(PlanNode planNode, boolean isGeneratedByPipe) {
        this(planNode, null, 0L, null, null, isGeneratedByPipe);
    }

    public PipeSchemaRegionWritePlanEvent(PlanNode planNode, String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, PipePattern pattern, boolean isGeneratedByPipe) {
        super(pipeName, creationTime, pipeTaskMeta, pattern, isGeneratedByPipe);
        this.planNode = planNode;
    }

    public PlanNode getPlanNode() {
        return this.planNode;
    }

    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        return new PipeSchemaRegionWritePlanEvent(this.planNode, pipeName, creationTime, pipeTaskMeta, pattern, this.isGeneratedByPipe);
    }

    public ByteBuffer serializeToByteBuffer() {
        ByteBuffer planBuffer = this.planNode.serializeToByteBuffer();
        ByteBuffer result = ByteBuffer.allocate(2 + planBuffer.limit());
        ReadWriteIOUtils.write((byte)PipeSchemaSerializableEventType.SCHEMA_WRITE_PLAN.getType(), (ByteBuffer)result);
        ReadWriteIOUtils.write((Boolean)this.isGeneratedByPipe, (ByteBuffer)result);
        result.put(planBuffer);
        return result;
    }

    public void deserializeFromByteBuffer(ByteBuffer buffer) {
        this.isGeneratedByPipe = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        this.planNode = PlanNodeType.deserialize(buffer);
    }

    public String toString() {
        return String.format("PipeSchemaRegionWritePlanEvent{planNode=%s}", this.planNode) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeSchemaRegionWritePlanEvent{planNode=%s}", this.planNode) + " - " + super.coreReportMessage();
    }
}

