/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.pipe;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeTabletEventBatch;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeTabletIterationSnapshot;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeEvents;

public class SubscriptionPipeTabletBatchEvents
implements SubscriptionPipeEvents {
    private final SubscriptionPipeTabletEventBatch batch;
    private volatile SubscriptionPipeTabletIterationSnapshot iterationSnapshot;

    public SubscriptionPipeTabletBatchEvents(SubscriptionPipeTabletEventBatch batch) {
        this.batch = batch;
    }

    public void receiveIterationSnapshot(SubscriptionPipeTabletIterationSnapshot iterationSnapshot) {
        this.iterationSnapshot = iterationSnapshot;
    }

    @Override
    public void ack() {
        this.batch.ack();
        if (Objects.nonNull(this.iterationSnapshot)) {
            this.iterationSnapshot.ack();
        }
    }

    @Override
    public void cleanUp(boolean force) {
        this.batch.cleanUp(force);
        if (Objects.nonNull(this.iterationSnapshot)) {
            this.iterationSnapshot.cleanUp();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("batch", (Object)this.batch).add("events", (Object)(Objects.nonNull(this.iterationSnapshot) ? SubscriptionPipeTabletBatchEvents.formatEnrichedEvents(this.iterationSnapshot.getIteratedEnrichedEvents(), 4) : "<unknown>")).toString();
    }

    private static String formatEnrichedEvents(List<EnrichedEvent> enrichedEvents, int threshold) {
        if (Objects.isNull(enrichedEvents)) {
            return "[]";
        }
        List eventMessageList = enrichedEvents.stream().limit(threshold).map(EnrichedEvent::coreReportMessage).collect(Collectors.toList());
        if (enrichedEvents.size() > threshold) {
            eventMessageList.add(String.format("omit the remaining %s event(s)...", enrichedEvents.size() - threshold));
        }
        return eventMessageList.toString();
    }

    @Override
    public int getPipeEventCount() {
        return Objects.nonNull(this.iterationSnapshot) ? this.iterationSnapshot.getIteratedEnrichedEvents().size() : 0;
    }
}

