/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.analyze.TemplatedInfo;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.utils.TypeUtil;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class TypeProvider {
    private final Map<String, TSDataType> treeModelTypeMap;
    private TemplatedInfo templatedInfo;
    private Map<Symbol, Type> tableModelTypes = new HashMap<Symbol, Type>();

    public TypeProvider() {
        this.treeModelTypeMap = new HashMap<String, TSDataType>();
    }

    public TypeProvider(Map<String, TSDataType> treeModelTypeMap, TemplatedInfo templatedInfo) {
        this.treeModelTypeMap = treeModelTypeMap;
        this.templatedInfo = templatedInfo;
        this.treeModelTypeMap.putIfAbsent("Time", TSDataType.INT64);
        this.tableModelTypes = null;
    }

    public TSDataType getTreeModelType(String symbol) {
        TSDataType type = this.treeModelTypeMap.get(symbol);
        if (this.templatedInfo == null || type != null) {
            return type;
        }
        IMeasurementSchema schema = this.templatedInfo.getSchemaMap().get(symbol);
        return schema == null ? null : schema.getType();
    }

    public void setTreeModelType(String symbol, TSDataType dataType) {
        if (dataType != null) {
            this.treeModelTypeMap.put(symbol, dataType);
        }
    }

    public Map<String, TSDataType> getTreeModelTypeMap() {
        return this.treeModelTypeMap;
    }

    public void setTemplatedInfo(TemplatedInfo templatedInfo) {
        this.templatedInfo = templatedInfo;
    }

    public TemplatedInfo getTemplatedInfo() {
        return this.templatedInfo;
    }

    public static TypeProvider viewOf(Map<Symbol, Type> types) {
        return new TypeProvider(types);
    }

    public static TypeProvider copyOf(Map<Symbol, Type> types) {
        return new TypeProvider((Map<Symbol, Type>)ImmutableMap.copyOf(types));
    }

    public static TypeProvider empty() {
        return new TypeProvider((Map<Symbol, Type>)ImmutableMap.of());
    }

    public TypeProvider(Map<Symbol, Type> tableModelTypes) {
        this.tableModelTypes = tableModelTypes;
        this.treeModelTypeMap = null;
    }

    public TypeProvider(Map<String, TSDataType> treeModelTypeMap, TemplatedInfo templatedInfo, Map<Symbol, Type> tableModelTypes) {
        this.treeModelTypeMap = treeModelTypeMap;
        this.templatedInfo = templatedInfo;
        this.tableModelTypes = tableModelTypes;
    }

    public Type getTableModelType(Symbol symbol) {
        Objects.requireNonNull(symbol, "symbol is null");
        Type type = this.tableModelTypes.get(symbol);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"no type found for symbol '%s' in TypeProvider", (Object)symbol);
        return type;
    }

    public boolean isSymbolExist(Symbol symbol) {
        return this.tableModelTypes.containsKey(symbol);
    }

    public void putTableModelType(Symbol symbol, Type type) {
        Objects.requireNonNull(symbol, "symbol is null");
        this.tableModelTypes.put(symbol, type);
    }

    public Map<Symbol, Type> allTableModelTypes() {
        return Collections.unmodifiableMap(this.tableModelTypes);
    }

    public void setTableModelTypes(Map<Symbol, Type> tableModelTypes) {
        this.tableModelTypes = tableModelTypes;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.treeModelTypeMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<String, TSDataType> entry : this.treeModelTypeMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)entry.getValue().ordinal(), (ByteBuffer)byteBuffer);
        }
        if (this.templatedInfo == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.templatedInfo.serialize(byteBuffer);
        }
        if (this.tableModelTypes == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((int)this.tableModelTypes.size(), (ByteBuffer)byteBuffer);
            for (Map.Entry<Object, Object> entry : this.tableModelTypes.entrySet()) {
                ReadWriteIOUtils.write((String)((Symbol)entry.getKey()).getName(), (ByteBuffer)byteBuffer);
                TypeUtil.serialize((Type)entry.getValue(), byteBuffer);
            }
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)(this.treeModelTypeMap == null ? 0 : this.treeModelTypeMap.size()), (OutputStream)stream);
        if (this.treeModelTypeMap != null) {
            for (Map.Entry<String, TSDataType> entry : this.treeModelTypeMap.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)stream);
                ReadWriteIOUtils.write((int)entry.getValue().ordinal(), (OutputStream)stream);
            }
        }
        if (this.templatedInfo == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.templatedInfo.serialize(stream);
        }
        if (this.tableModelTypes == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.tableModelTypes.size(), (OutputStream)stream);
            for (Map.Entry<Object, Object> entry : this.tableModelTypes.entrySet()) {
                ReadWriteIOUtils.write((String)((Symbol)entry.getKey()).getName(), (OutputStream)stream);
                TypeUtil.serialize((Type)entry.getValue(), stream);
            }
        }
    }

    public static TypeProvider deserialize(ByteBuffer byteBuffer) {
        int mapSize;
        HashMap<String, TSDataType> typeMap = new HashMap<String, TSDataType>(mapSize);
        for (mapSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); mapSize > 0; --mapSize) {
            typeMap.put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), TSDataType.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)]);
        }
        TemplatedInfo templatedInfo = null;
        byte hasTemplatedInfo = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        if (hasTemplatedInfo == 1) {
            templatedInfo = TemplatedInfo.deserialize(byteBuffer);
        }
        HashMap<Symbol, Type> tableModelTypes = null;
        byte hasTableModelTypes = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        if (hasTableModelTypes == 1) {
            tableModelTypes = new HashMap<Symbol, Type>(mapSize);
            for (mapSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); mapSize > 0; --mapSize) {
                tableModelTypes.put(new Symbol(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer)), TypeUtil.deserialize(byteBuffer));
            }
        }
        return new TypeProvider(typeMap, templatedInfo, tableModelTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeProvider that = (TypeProvider)o;
        return Objects.equals(this.treeModelTypeMap, that.treeModelTypeMap);
    }

    public int hashCode() {
        return Objects.hash(this.treeModelTypeMap);
    }
}

