/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.memory;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.memory.StatementMemorySource;
import org.apache.iotdb.db.queryengine.plan.execution.memory.StatementMemorySourceVisitor;
import org.apache.iotdb.db.queryengine.plan.execution.memory.TableModelStatementMemorySourceContext;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanGraphPrinter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.TableLogicalPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.distribute.TableDistributedPlanGenerator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.distribute.TableDistributedPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CountDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Explain;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDevice;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;

public class TableModelStatementMemorySourceVisitor
extends AstVisitor<StatementMemorySource, TableModelStatementMemorySourceContext> {
    @Override
    public StatementMemorySource visitNode(Node node, TableModelStatementMemorySourceContext context) {
        DatasetHeader datasetHeader = context.getAnalysis().getRespDatasetHeader();
        return new StatementMemorySource(new TsBlock(0), datasetHeader == null ? DatasetHeader.EMPTY_HEADER : datasetHeader);
    }

    @Override
    public StatementMemorySource visitExplain(Explain node, TableModelStatementMemorySourceContext context) {
        context.getAnalysis().setStatement(node.getStatement());
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        DatasetHeader header = new DatasetHeader(Collections.singletonList(new ColumnHeader("distribution plan", TSDataType.TEXT)), true);
        LogicalQueryPlan logicalPlan = new TableLogicalPlanner(context.getQueryContext(), LocalExecutionPlanner.getInstance().metadata, context.getQueryContext().getSession(), symbolAllocator, WarningCollector.NOOP, Coordinator.getInstance().getLogicalPlanOptimizers()).plan(context.getAnalysis());
        if (context.getAnalysis().isEmptyDataSource()) {
            return new StatementMemorySource(new TsBlock(0), header);
        }
        TableDistributedPlanGenerator.PlanContext planContext = new TableDistributedPlanGenerator.PlanContext();
        PlanNode outputNodeWithExchange = new TableDistributedPlanner(context.getAnalysis(), symbolAllocator, logicalPlan, LocalExecutionPlanner.getInstance().metadata, Coordinator.getInstance().getDistributionPlanOptimizers(), Coordinator.getInstance().getDataNodeLocationSupplier()).generateDistributedPlanWithOptimize(planContext);
        List<String> lines = outputNodeWithExchange.accept(new PlanGraphPrinter(), new PlanGraphPrinter.GraphContext(context.getQueryContext().getTypeProvider().getTemplatedInfo()));
        return StatementMemorySourceVisitor.getStatementMemorySource(header, lines);
    }

    @Override
    public StatementMemorySource visitShowDevice(ShowDevice node, TableModelStatementMemorySourceContext context) {
        return new StatementMemorySource(node.getTsBlock(context.getAnalysis()), node.getDataSetHeader());
    }

    @Override
    public StatementMemorySource visitCountDevice(CountDevice node, TableModelStatementMemorySourceContext context) {
        return new StatementMemorySource(node.getTsBlock(context.getAnalysis()), node.getDataSetHeader());
    }
}

