/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByConditionParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByCountParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupBySessionParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByVariationParameter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class GroupByParameter {
    protected WindowType windowType;

    public GroupByParameter(WindowType windowType) {
        this.windowType = windowType;
    }

    public WindowType getWindowType() {
        return this.windowType;
    }

    protected abstract void serializeAttributes(ByteBuffer var1);

    protected abstract void serializeAttributes(DataOutputStream var1) throws IOException;

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((byte)this.windowType.getType(), (ByteBuffer)buffer);
        this.serializeAttributes(buffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)this.windowType.getType(), (OutputStream)stream);
        this.serializeAttributes(stream);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupByParameter)) {
            return false;
        }
        GroupByParameter other = (GroupByParameter)obj;
        return this.windowType == other.windowType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.windowType});
    }

    public static GroupByParameter deserialize(ByteBuffer byteBuffer) {
        byte type = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        if (type == WindowType.VARIATION_WINDOW.getType()) {
            return GroupByVariationParameter.deserialize(byteBuffer);
        }
        if (type == WindowType.CONDITION_WINDOW.getType()) {
            return GroupByConditionParameter.deserialize(byteBuffer);
        }
        if (type == WindowType.SESSION_WINDOW.getType()) {
            return GroupBySessionParameter.deserialize(byteBuffer);
        }
        if (type == WindowType.COUNT_WINDOW.getType()) {
            return GroupByCountParameter.deserialize(byteBuffer);
        }
        throw new SemanticException("Unsupported window type");
    }
}

