/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.binary;

import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TransformUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;

public abstract class CompareBinaryColumnTransformer
extends BinaryColumnTransformer {
    protected CompareBinaryColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        if (leftColumn.mayHaveNull() && leftColumn instanceof RunLengthEncodedColumn || rightColumn.mayHaveNull() && rightColumn instanceof RunLengthEncodedColumn) {
            builder.appendNull(positionCount);
            return;
        }
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.evaluateAndTransform(leftColumn, rightColumn, i, builder);
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        if (leftColumn.mayHaveNull() && leftColumn instanceof RunLengthEncodedColumn || rightColumn.mayHaveNull() && rightColumn instanceof RunLengthEncodedColumn) {
            builder.appendNull(positionCount);
            return;
        }
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i] && !leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.evaluateAndTransform(leftColumn, rightColumn, i, builder);
                continue;
            }
            builder.appendNull();
        }
    }

    private void evaluateAndTransform(Column leftColumn, Column rightColumn, int index, ColumnBuilder builder) {
        boolean flag = false;
        if (TableMetadataImpl.isCharType(this.leftTransformer.getType()) || TableMetadataImpl.isBlobType(this.leftTransformer.getType())) {
            flag = this.transform(TransformUtils.compare(this.leftTransformer.getType().getBinary(leftColumn, index), this.rightTransformer.getType().getBinary(rightColumn, index)));
        } else if (TableMetadataImpl.isBool(this.leftTransformer.getType())) {
            flag = this.transform(Boolean.compare(this.leftTransformer.getType().getBoolean(leftColumn, index), this.rightTransformer.getType().getBoolean(rightColumn, index)));
        } else {
            double left = this.leftTransformer.getType().getDouble(leftColumn, index);
            double right = this.rightTransformer.getType().getDouble(rightColumn, index);
            if (!Double.isNaN(left) && !Double.isNaN(right)) {
                flag = this.transform(Double.compare(left, right));
            }
        }
        this.returnType.writeBoolean(builder, flag);
    }

    @Override
    protected void checkType() {
        if (this.leftTransformer.typeNotEquals(TypeEnum.BOOLEAN) && this.rightTransformer.typeNotEquals(TypeEnum.BOOLEAN)) {
            return;
        }
        throw new UnsupportedOperationException("Unsupported Type");
    }

    protected abstract boolean transform(int var1);
}

