/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.pipe.service;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.runtime.RPCServiceException;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.ThriftService;
import org.apache.iotdb.commons.service.ThriftServiceThread;
import org.apache.iotdb.consensus.config.PipeConsensusConfig;
import org.apache.iotdb.consensus.pipe.service.PipeConsensusRPCServiceHandler;
import org.apache.iotdb.consensus.pipe.service.PipeConsensusRPCServiceMBean;
import org.apache.iotdb.consensus.pipe.service.PipeConsensusRPCServiceProcessor;
import org.apache.iotdb.consensus.pipe.thrift.PipeConsensusIService;
import org.apache.iotdb.rpc.ZeroCopyRpcTransportFactory;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.transport.TTransportFactory;

public class PipeConsensusRPCService
extends ThriftService
implements PipeConsensusRPCServiceMBean {
    private final TEndPoint thisNode;
    private final PipeConsensusConfig config;
    private PipeConsensusRPCServiceProcessor pipeConsensusRPCServiceProcessor;

    public PipeConsensusRPCService(TEndPoint thisNode, PipeConsensusConfig config) {
        this.thisNode = thisNode;
        this.config = config;
    }

    public ServiceType getID() {
        return ServiceType.PIPE_CONSENSUS_SERVICE;
    }

    public void initSyncedServiceImpl(Object pipeConsensusRPCServiceProcessor) {
        this.pipeConsensusRPCServiceProcessor = (PipeConsensusRPCServiceProcessor)pipeConsensusRPCServiceProcessor;
        super.initSyncedServiceImpl((Object)this.pipeConsensusRPCServiceProcessor);
    }

    public void initTProcessor() {
        this.processor = new PipeConsensusIService.Processor((PipeConsensusIService.Iface)this.pipeConsensusRPCServiceProcessor);
    }

    public void initThriftServiceThread() throws IllegalAccessException {
        try {
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.PIPE_CONSENSUS_RPC_PROCESSOR.getName(), this.getBindIP(), this.getBindPort(), this.config.getRpc().getRpcMaxConcurrentClientNum(), this.config.getRpc().getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new PipeConsensusRPCServiceHandler(this.pipeConsensusRPCServiceProcessor), this.config.getRpc().isRpcThriftCompressionEnabled(), (TTransportFactory)ZeroCopyRpcTransportFactory.INSTANCE);
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.PIPE_CONSENSUS_RPC_SERVICE.getName());
    }

    public String getBindIP() {
        return this.thisNode.getIp();
    }

    public int getBindPort() {
        return this.thisNode.getPort();
    }
}

