/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DeviceUpdater;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.LeafColumnTransformer;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.IMemMNode;
import org.apache.tsfile.utils.Binary;

public class DeviceBlackListConstructor
extends DeviceUpdater {
    private final List<IDeviceMNode<IMemMNode>> nodes = new ArrayList<IDeviceMNode<IMemMNode>>(DEFAULT_MAX_TS_BLOCK_LINE_NUMBER);
    private long preDeletedNum = 0L;
    private final MemSchemaRegionStatistics regionStatistics;
    private final String tableName;

    public DeviceBlackListConstructor(List<LeafColumnTransformer> filterLeafColumnTransformerList, ColumnTransformer filterOutputTransformer, String tableName, List<TsTableColumnSchema> columnSchemaList, BiFunction<Integer, String, Binary> attributeProvider, MemSchemaRegionStatistics regionStatistics, String database, TsTable table) {
        super(filterLeafColumnTransformerList, filterOutputTransformer, columnSchemaList, attributeProvider, database, table);
        this.tableName = tableName;
        this.regionStatistics = regionStatistics;
    }

    @Override
    public void handleDeviceNode(IDeviceMNode<IMemMNode> node) throws MetadataException {
        if (this.withoutFilter()) {
            node.preDeactivateSelfOrTemplate();
            ++this.preDeletedNum;
            this.regionStatistics.decreaseTableDevice(this.tableName, 1L);
            return;
        }
        this.nodes.add(node);
        super.handleDeviceNode(node);
    }

    @Override
    protected void update() {
        this.preDeletedNum += (long)this.indexes.size();
        this.regionStatistics.decreaseTableDevice(this.tableName, this.indexes.size());
        for (Integer index : this.indexes) {
            this.nodes.get(index).preDeactivateSelfOrTemplate();
        }
        this.nodes.clear();
        super.clear();
    }

    public long getPreDeletedNum() {
        return this.preDeletedNum;
    }
}

