/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.multi;

import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.InMultiColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.type.Type;

public class InDoubleMultiColumnTransformer
extends InMultiColumnTransformer {
    private final Set<Double> constantSet;

    public InDoubleMultiColumnTransformer(Set<Double> constantSet, List<ColumnTransformer> columnTransformerList) {
        super(columnTransformerList);
        this.constantSet = constantSet;
    }

    @Override
    protected boolean satisfy(List<Column> childrenColumns, int index) {
        double value = childrenColumns.get(0).getDouble(index);
        if (this.constantSet.contains(value)) {
            return true;
        }
        int size = childrenColumns.size();
        for (int i = 1; i < size; ++i) {
            Type valueType;
            Column valueColumn = childrenColumns.get(i);
            if (valueColumn.isNull(i) || (valueType = ((ColumnTransformer)this.columnTransformerList.get(i)).getType()).getDouble(valueColumn, index) != value) continue;
            return true;
        }
        return false;
    }
}

