/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.iotdb.consensus.ratis.metrics.CounterProxy;
import org.apache.iotdb.consensus.ratis.metrics.GaugeProxy;
import org.apache.iotdb.consensus.ratis.metrics.TimerProxy;
import org.apache.iotdb.consensus.ratis.utils.Utils;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.ratis.metrics.LongCounter;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.Timekeeper;

public class IoTDBMetricRegistry
implements RatisMetricRegistry {
    private final AbstractMetricService metricService;
    private final MetricRegistryInfo info;
    private final String prefix;
    private final Map<String, String> metricNameCache = new ConcurrentHashMap<String, String>();
    private final Map<String, CounterProxy> counterCache = new ConcurrentHashMap<String, CounterProxy>();
    private final Map<String, TimerProxy> timerCache = new ConcurrentHashMap<String, TimerProxy>();
    private final Map<String, Boolean> gaugeCache = new ConcurrentHashMap<String, Boolean>();
    public static final String RAFT_LOG_FLUSH_TIME = "flushTime";
    public static final String RAFT_LOG_CACHE_CLOSED_SEGMENTS_SIZE_IN_BYTES = "closedSegmentsSizeInBytes";
    public static final String RAFT_LOG_CACHE_OPEN_SEGMENT_SIZE_IN_BYTES = "openSegmentSizeInBytes";
    public static final String RAFT_LOG_APPEND_ENTRY_LATENCY = "appendEntryLatency";
    public static final String RAFT_LOG_TASK_ENQUEUE_DELAY = "queueingDelay";
    public static final String RAFT_LOG_TASK_QUEUE_TIME = "enqueuedTime";
    public static final String RAFT_LOG_TASK_EXECUTION_TIME = "ExecutionTime";
    public static final String FOLLOWER_APPEND_ENTRIES_LATENCY = "follower_append_entry_latency";
    public static final String RAFT_CLIENT_WRITE_REQUEST = "clientWriteRequest";
    private static final List<String> RATIS_METRICS = new ArrayList<String>();

    IoTDBMetricRegistry(MetricRegistryInfo info, AbstractMetricService service) {
        this.info = info;
        this.metricService = service;
        this.prefix = Utils.getConsensusGroupTypeFromPrefix(info.getPrefix()).toString() + info.getApplicationName() + info.getMetricsComponentName();
    }

    private String getMetricName(String name) {
        return this.metricNameCache.computeIfAbsent(name, n -> this.prefix + n);
    }

    public MetricLevel getMetricLevel(String name) {
        for (String ratisMetric : RATIS_METRICS) {
            if (!name.contains(ratisMetric)) continue;
            return MetricLevel.IMPORTANT;
        }
        return MetricLevel.CORE;
    }

    public Timekeeper timer(String name) {
        String fullName = this.getMetricName(name);
        return this.timerCache.computeIfAbsent(fullName, fn -> new TimerProxy(this.metricService.getOrCreateTimer(fn, this.getMetricLevel(fullName), new String[0])));
    }

    public LongCounter counter(String name) {
        String fullName = this.getMetricName(name);
        return this.counterCache.computeIfAbsent(fullName, fn -> new CounterProxy(this.metricService.getOrCreateCounter(this.getMetricName(name), this.getMetricLevel(fullName), new String[0])));
    }

    public boolean remove(String name) {
        try {
            this.metricService.remove(MetricType.COUNTER, this.getMetricName(name), new String[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.metricService.remove(MetricType.TIMER, this.getMetricName(name), new String[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.metricService.remove(MetricType.AUTO_GAUGE, this.getMetricName(name), new String[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }

    public <T> void gauge(String name, Supplier<Supplier<T>> supplier) {
        String fullName = this.getMetricName(name);
        this.gaugeCache.computeIfAbsent(fullName, fn -> {
            GaugeProxy gauge = new GaugeProxy(supplier);
            this.metricService.createAutoGauge(fn, this.getMetricLevel((String)fn), gauge, GaugeProxy::getDoubleValue, new String[0]);
            return true;
        });
    }

    public MetricRegistryInfo getMetricRegistryInfo() {
        return this.info;
    }

    void removeAll() {
        this.counterCache.forEach((name, counter) -> this.metricService.remove(MetricType.COUNTER, name, new String[0]));
        this.gaugeCache.forEach((name, gauge) -> this.metricService.remove(MetricType.AUTO_GAUGE, name, new String[0]));
        this.timerCache.forEach((name, timer) -> this.metricService.remove(MetricType.TIMER, name, new String[0]));
        this.metricNameCache.clear();
        this.counterCache.clear();
        this.gaugeCache.clear();
        this.timerCache.clear();
    }

    static {
        RATIS_METRICS.add(RAFT_LOG_FLUSH_TIME);
        RATIS_METRICS.add(RAFT_LOG_CACHE_CLOSED_SEGMENTS_SIZE_IN_BYTES);
        RATIS_METRICS.add(RAFT_LOG_CACHE_OPEN_SEGMENT_SIZE_IN_BYTES);
        RATIS_METRICS.add(RAFT_LOG_APPEND_ENTRY_LATENCY);
        RATIS_METRICS.add(RAFT_LOG_TASK_ENQUEUE_DELAY);
        RATIS_METRICS.add(RAFT_LOG_TASK_QUEUE_TIME);
        RATIS_METRICS.add(RAFT_LOG_TASK_EXECUTION_TIME);
        RATIS_METRICS.add(FOLLOWER_APPEND_ENTRIES_LATENCY);
        RATIS_METRICS.add(RAFT_CLIENT_WRITE_REQUEST);
    }
}

