/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.mime4j.storage.CipherStorageProvider;
import org.apache.james.mime4j.storage.MemoryStorageProvider;
import org.apache.james.mime4j.storage.Storage;
import org.apache.james.mime4j.storage.StorageOutputStream;
import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.storage.TempFileStorageProvider;
import org.apache.james.mime4j.storage.ThresholdStorageProvider;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Assert;
import org.junit.Test;

public class StorageProviderTest {
    @Test
    public void testMemoryStorageProvider() throws Exception {
        MemoryStorageProvider provider = new MemoryStorageProvider();
        this.testReadWrite((StorageProvider)provider, 0);
        this.testReadWrite((StorageProvider)provider, 1);
        this.testReadWrite((StorageProvider)provider, 1024);
        this.testReadWrite((StorageProvider)provider, 20000);
        this.testDelete((StorageProvider)provider);
    }

    @Test
    public void testTempFileStorageProvider() throws Exception {
        TempFileStorageProvider provider = new TempFileStorageProvider();
        this.testReadWrite((StorageProvider)provider, 0);
        this.testReadWrite((StorageProvider)provider, 1);
        this.testReadWrite((StorageProvider)provider, 1024);
        this.testReadWrite((StorageProvider)provider, 20000);
        this.testDelete((StorageProvider)provider);
    }

    @Test
    public void testThresholdStorageProvider() throws Exception {
        int threshold = 5000;
        TempFileStorageProvider backend = new TempFileStorageProvider();
        ThresholdStorageProvider provider = new ThresholdStorageProvider((StorageProvider)backend, 5000);
        this.testReadWrite((StorageProvider)provider, 0);
        this.testReadWrite((StorageProvider)provider, 1);
        this.testReadWrite((StorageProvider)provider, 4999);
        this.testReadWrite((StorageProvider)provider, 5000);
        this.testReadWrite((StorageProvider)provider, 5001);
        this.testReadWrite((StorageProvider)provider, 10000);
        this.testReadWrite((StorageProvider)provider, 50000);
        this.testDelete((StorageProvider)provider);
    }

    @Test
    public void testCipherStorageProvider() throws Exception {
        TempFileStorageProvider backend = new TempFileStorageProvider();
        CipherStorageProvider provider = new CipherStorageProvider((StorageProvider)backend);
        this.testReadWrite((StorageProvider)provider, 0);
        this.testReadWrite((StorageProvider)provider, 1);
        this.testReadWrite((StorageProvider)provider, 1024);
        this.testReadWrite((StorageProvider)provider, 20000);
        this.testDelete((StorageProvider)provider);
    }

    private void testReadWrite(StorageProvider provider, int size) throws IOException {
        this.testStore(provider, size);
        this.testCreateStorageOutputStream(provider, size);
    }

    private void testStore(StorageProvider provider, int size) throws IOException {
        byte[] data = this.createData(size);
        Assert.assertEquals((long)size, (long)data.length);
        Storage storage = provider.store((InputStream)new ByteArrayInputStream(data));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ContentUtil.copy((InputStream)storage.getInputStream(), (OutputStream)baos);
        this.verifyData(data, baos.toByteArray());
    }

    private void testCreateStorageOutputStream(StorageProvider provider, int size) throws IOException {
        byte[] data = this.createData(size);
        Assert.assertEquals((long)size, (long)data.length);
        StorageOutputStream out = provider.createStorageOutputStream();
        ContentUtil.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)out);
        Storage storage = out.toStorage();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ContentUtil.copy((InputStream)storage.getInputStream(), (OutputStream)baos);
        this.verifyData(data, baos.toByteArray());
    }

    private void verifyData(byte[] expected, byte[] actual) {
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((long)expected[i], (long)actual[i]);
        }
    }

    private byte[] createData(int size) {
        byte[] data = new byte[size];
        for (int i = 0; i < size; ++i) {
            data[i] = (byte)i;
        }
        return data;
    }

    private void testDelete(StorageProvider provider) throws IOException {
        Storage storage = provider.store((InputStream)new ByteArrayInputStream(this.createData(512)));
        storage.delete();
        try {
            storage.getInputStream();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        storage.delete();
    }
}

