/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.MultiTermLookup;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class MultiTermsAggregation
extends BucketAggregationBase
implements AggregationVariant {
    private final List<MultiTermLookup> terms;
    public static final JsonpDeserializer<MultiTermsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiTermsAggregation::setupMultiTermsAggregationDeserializer);

    private MultiTermsAggregation(Builder builder) {
        super(builder);
        this.terms = ApiTypeHelper.unmodifiableRequired(builder.terms, (Object)this, "terms");
    }

    public static MultiTermsAggregation of(Function<Builder, ObjectBuilder<MultiTermsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.MultiTerms;
    }

    public final List<MultiTermLookup> terms() {
        return this.terms;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.terms)) {
            generator.writeKey("terms");
            generator.writeStartArray();
            for (MultiTermLookup item0 : this.terms) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupMultiTermsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::terms, JsonpDeserializer.arrayDeserializer(MultiTermLookup._DESERIALIZER), "terms");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MultiTermsAggregation> {
        private List<MultiTermLookup> terms;

        public final Builder terms(List<MultiTermLookup> list) {
            this.terms = Builder._listAddAll(this.terms, list);
            return this;
        }

        public final Builder terms(MultiTermLookup value, MultiTermLookup ... values) {
            this.terms = Builder._listAdd(this.terms, value, values);
            return this;
        }

        public final Builder terms(Function<MultiTermLookup.Builder, ObjectBuilder<MultiTermLookup>> fn) {
            return this.terms(fn.apply(new MultiTermLookup.Builder()).build(), new MultiTermLookup[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiTermsAggregation build() {
            this._checkSingleUse();
            return new MultiTermsAggregation(this);
        }
    }
}

