/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ClusterJvmVersion
implements JsonpSerializable {
    private final boolean bundledJdk;
    private final int count;
    private final boolean usingBundledJdk;
    private final String version;
    private final String vmName;
    private final String vmVendor;
    private final String vmVersion;
    public static final JsonpDeserializer<ClusterJvmVersion> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterJvmVersion::setupClusterJvmVersionDeserializer);

    private ClusterJvmVersion(Builder builder) {
        this.bundledJdk = ApiTypeHelper.requireNonNull(builder.bundledJdk, this, "bundledJdk");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.usingBundledJdk = ApiTypeHelper.requireNonNull(builder.usingBundledJdk, this, "usingBundledJdk");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.vmName = ApiTypeHelper.requireNonNull(builder.vmName, this, "vmName");
        this.vmVendor = ApiTypeHelper.requireNonNull(builder.vmVendor, this, "vmVendor");
        this.vmVersion = ApiTypeHelper.requireNonNull(builder.vmVersion, this, "vmVersion");
    }

    public static ClusterJvmVersion of(Function<Builder, ObjectBuilder<ClusterJvmVersion>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean bundledJdk() {
        return this.bundledJdk;
    }

    public final int count() {
        return this.count;
    }

    public final boolean usingBundledJdk() {
        return this.usingBundledJdk;
    }

    public final String version() {
        return this.version;
    }

    public final String vmName() {
        return this.vmName;
    }

    public final String vmVendor() {
        return this.vmVendor;
    }

    public final String vmVersion() {
        return this.vmVersion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bundled_jdk");
        generator.write(this.bundledJdk);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("using_bundled_jdk");
        generator.write(this.usingBundledJdk);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("vm_name");
        generator.write(this.vmName);
        generator.writeKey("vm_vendor");
        generator.write(this.vmVendor);
        generator.writeKey("vm_version");
        generator.write(this.vmVersion);
    }

    protected static void setupClusterJvmVersionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bundledJdk, JsonpDeserializer.booleanDeserializer(), "bundled_jdk");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::usingBundledJdk, JsonpDeserializer.booleanDeserializer(), "using_bundled_jdk");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::vmName, JsonpDeserializer.stringDeserializer(), "vm_name");
        op.add(Builder::vmVendor, JsonpDeserializer.stringDeserializer(), "vm_vendor");
        op.add(Builder::vmVersion, JsonpDeserializer.stringDeserializer(), "vm_version");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterJvmVersion> {
        private Boolean bundledJdk;
        private Integer count;
        private Boolean usingBundledJdk;
        private String version;
        private String vmName;
        private String vmVendor;
        private String vmVersion;

        public final Builder bundledJdk(boolean value) {
            this.bundledJdk = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder usingBundledJdk(boolean value) {
            this.usingBundledJdk = value;
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        public final Builder vmName(String value) {
            this.vmName = value;
            return this;
        }

        public final Builder vmVendor(String value) {
            this.vmVendor = value;
            return this;
        }

        public final Builder vmVersion(String value) {
            this.vmVersion = value;
            return this;
        }

        @Override
        public ClusterJvmVersion build() {
            this._checkSingleUse();
            return new ClusterJvmVersion(this);
        }
    }
}

