/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.LongStream;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.table.CassandraMessageUidTable;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public class CassandraUidProvider
implements UidProvider {
    private static final String CONDITION = "Condition";
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement updateStatement;
    private final PreparedStatement selectStatement;
    private final DriverExecutionProfile lwtProfile;
    private final RetryBackoffSpec retrySpec;
    private final CassandraConfiguration cassandraConfiguration;

    @Inject
    public CassandraUidProvider(CqlSession session, CassandraConfiguration cassandraConfiguration) {
        this.executor = new CassandraAsyncExecutor(session);
        this.lwtProfile = JamesExecutionProfiles.getLWTProfile((CqlSession)session);
        this.selectStatement = this.prepareSelect(session);
        this.updateStatement = this.prepareUpdate(session);
        this.insertStatement = this.prepareInsert(session);
        Duration firstBackoff = Duration.ofMillis(10L);
        this.retrySpec = Retry.backoff((long)cassandraConfiguration.getUidMaxRetry(), (Duration)firstBackoff).scheduler(Schedulers.parallel());
        this.cassandraConfiguration = cassandraConfiguration;
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageCounter").column(CassandraMessageUidTable.NEXT_UID).where((Relation)Relation.column((CqlIdentifier)CassandraMessageUidTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageUidTable.MAILBOX_ID)))).build());
    }

    private PreparedStatement prepareUpdate(CqlSession session) {
        return session.prepare(((Update)((Update)QueryBuilder.update((String)"messageCounter").setColumn(CassandraMessageUidTable.NEXT_UID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageUidTable.NEXT_UID)).where((Relation)Relation.column((CqlIdentifier)CassandraMessageUidTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageUidTable.MAILBOX_ID)))).ifColumn(CassandraMessageUidTable.NEXT_UID).isEqualTo((Term)QueryBuilder.bindMarker((String)CONDITION))).build());
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"messageCounter").value(CassandraMessageUidTable.NEXT_UID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageUidTable.NEXT_UID)).value(CassandraMessageUidTable.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageUidTable.MAILBOX_ID)).ifNotExists().build());
    }

    public MessageUid nextUid(Mailbox mailbox) throws MailboxException {
        return this.nextUid(mailbox.getMailboxId());
    }

    public MessageUid nextUid(MailboxId mailboxId) throws MailboxException {
        CassandraId cassandraId = (CassandraId)mailboxId;
        return (MessageUid)this.nextUidReactive(cassandraId).blockOptional().orElseThrow(() -> new MailboxException("Error during Uid update"));
    }

    public Mono<MessageUid> nextUidReactive(MailboxId mailboxId) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        Mono updateUid = this.findHighestUid(cassandraId, Optional.of(this.lwtProfile)).flatMap(messageUid -> this.tryUpdateUid(cassandraId, (MessageUid)messageUid));
        return updateUid.switchIfEmpty(this.tryInsert(cassandraId)).switchIfEmpty(updateUid).single().retryWhen((Retry)this.retrySpec);
    }

    public Mono<List<MessageUid>> nextUids(MailboxId mailboxId, int count) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        Mono updateUid = this.findHighestUid(cassandraId, Optional.of(this.lwtProfile)).flatMap(messageUid -> this.tryUpdateUid(cassandraId, (MessageUid)messageUid, count).map(highest -> this.range((MessageUid)messageUid, (MessageUid)highest)));
        return updateUid.switchIfEmpty(this.tryInsert(cassandraId, count).map(highest -> this.range(MessageUid.MIN_VALUE, (MessageUid)highest))).switchIfEmpty(updateUid).single().retryWhen((Retry)this.retrySpec);
    }

    private List<MessageUid> range(MessageUid lowerExclusive, MessageUid higherInclusive) {
        return (List)LongStream.range(lowerExclusive.asLong() + 1L, higherInclusive.asLong() + 1L).mapToObj(MessageUid::of).collect(ImmutableList.toImmutableList());
    }

    public Optional<MessageUid> lastUid(Mailbox mailbox) {
        return this.findHighestUid((CassandraId)mailbox.getMailboxId(), Optional.of(this.lwtProfile).filter(any -> this.cassandraConfiguration.isUidReadStrongConsistency())).blockOptional();
    }

    public Mono<Optional<MessageUid>> lastUidReactive(Mailbox mailbox) {
        return this.findHighestUid((CassandraId)mailbox.getMailboxId(), Optional.of(this.lwtProfile).filter(any -> this.cassandraConfiguration.isUidReadStrongConsistency())).map(Optional::of).switchIfEmpty(Mono.just(Optional.empty()));
    }

    private Mono<MessageUid> findHighestUid(CassandraId mailboxId, Optional<DriverExecutionProfile> executionProfile) {
        BoundStatement statement = (BoundStatement)this.selectStatement.bind(new Object[0]).set(CassandraMessageUidTable.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID);
        return this.executor.executeSingleRow((Statement)executionProfile.map(arg_0 -> ((BoundStatement)statement).setExecutionProfile(arg_0)).orElse(statement)).map(row -> MessageUid.of((long)row.getLong(0)));
    }

    private Mono<MessageUid> tryUpdateUid(CassandraId mailboxId, MessageUid uid) {
        return this.tryUpdateUid(mailboxId, uid, 1);
    }

    private Mono<MessageUid> tryUpdateUid(CassandraId mailboxId, MessageUid uid, int count) {
        MessageUid nextUid = uid.next(count);
        return this.executor.executeReturnApplied((Statement)((BoundStatement)((BoundStatement)this.updateStatement.bind(new Object[0]).set(CassandraMessageUidTable.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setLong(CONDITION, uid.asLong())).setLong(CassandraMessageUidTable.NEXT_UID, nextUid.asLong())).map(success -> this.successToUid(nextUid, (Boolean)success)).handle(ReactorUtils.publishIfPresent());
    }

    private Mono<MessageUid> tryInsert(CassandraId mailboxId) {
        return this.executor.executeReturnApplied((Statement)((BoundStatement)this.insertStatement.bind(new Object[0]).setLong(CassandraMessageUidTable.NEXT_UID, MessageUid.MIN_VALUE.asLong())).setUuid(CassandraMessageUidTable.MAILBOX_ID, mailboxId.asUuid())).map(success -> this.successToUid(MessageUid.MIN_VALUE, (Boolean)success)).handle(ReactorUtils.publishIfPresent());
    }

    private Mono<MessageUid> tryInsert(CassandraId mailboxId, int count) {
        return this.executor.executeReturnApplied((Statement)((BoundStatement)this.insertStatement.bind(new Object[0]).setLong(CassandraMessageUidTable.NEXT_UID, MessageUid.MIN_VALUE.next(count).asLong())).setUuid(CassandraMessageUidTable.MAILBOX_ID, mailboxId.asUuid())).map(success -> this.successToUid(MessageUid.MIN_VALUE.next(count), (Boolean)success)).handle(ReactorUtils.publishIfPresent());
    }

    private Optional<MessageUid> successToUid(MessageUid uid, Boolean success) {
        if (success.booleanValue()) {
            return Optional.of(uid);
        }
        return Optional.empty();
    }
}

