/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupPartitionMetadataValue;

public class TopicMetadata {
    private final Uuid id;
    private final String name;
    private final int numPartitions;

    public TopicMetadata(Uuid id, String name, int numPartitions) {
        this.id = Objects.requireNonNull(id);
        if (Uuid.ZERO_UUID.equals((Object)id)) {
            throw new IllegalArgumentException("Topic id cannot be ZERO_UUID.");
        }
        this.name = Objects.requireNonNull(name);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Topic name cannot be empty.");
        }
        this.numPartitions = numPartitions;
        if (numPartitions < 0) {
            throw new IllegalArgumentException("Number of partitions cannot be negative.");
        }
    }

    public Uuid id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicMetadata that = (TopicMetadata)o;
        if (!this.id.equals((Object)that.id)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.numPartitions == that.numPartitions;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.numPartitions;
        return result;
    }

    public String toString() {
        return "TopicMetadata(id=" + String.valueOf(this.id) + ", name=" + this.name + ", numPartitions=" + this.numPartitions + ")";
    }

    public static TopicMetadata fromRecord(ConsumerGroupPartitionMetadataValue.TopicMetadata record) {
        return new TopicMetadata(record.topicId(), record.topicName(), record.numPartitions());
    }

    public static TopicMetadata fromRecord(ShareGroupPartitionMetadataValue.TopicMetadata record) {
        return new TopicMetadata(record.topicId(), record.topicName(), record.numPartitions());
    }
}

