/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collections;
import java.util.Map;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.support.LRUCacheFactory;

public class DefaultEndpointUtilizationStatistics
implements EndpointUtilizationStatistics {
    private final int maxCapacity;
    private final Map<String, Long> map;

    public DefaultEndpointUtilizationStatistics(int maxCapacity) {
        this.map = LRUCacheFactory.newLRUCache((int)16, (int)maxCapacity, (boolean)false);
        this.maxCapacity = maxCapacity;
    }

    public int maxCapacity() {
        return this.maxCapacity;
    }

    public int size() {
        return this.map.size();
    }

    public void onHit(String uri) {
        this.map.compute(uri, (key, current) -> {
            if (current == null) {
                return 1L;
            }
            current = current + 1L;
            return current;
        });
    }

    public void remove(String uri) {
        this.map.remove(uri);
    }

    public Map<String, Long> getStatistics() {
        return Collections.unmodifiableMap(this.map);
    }

    public void clear() {
        this.map.clear();
    }
}

