/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.hadoopauth.deploy;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.hadoopauth.HadoopAuthMessages;
import org.apache.knox.gateway.hadoopauth.filter.HadoopAuthFilter;
import org.apache.knox.gateway.hadoopauth.filter.HadoopAuthPostFilter;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public class HadoopAuthDeploymentContributor
extends ProviderDeploymentContributorBase {
    private static HadoopAuthMessages log = (HadoopAuthMessages)MessagesFactory.get(HadoopAuthMessages.class);
    private static final String HADOOPAUTH_FILTER_CLASSNAME = HadoopAuthFilter.class.getCanonicalName();
    private static final String HADOOPAUTH_POSTFILTER_CLASSNAME = HadoopAuthPostFilter.class.getCanonicalName();
    public static final String ROLE = "authentication";
    public static final String NAME = "HadoopAuth";
    private AliasService as;

    public String getRole() {
        return ROLE;
    }

    public String getName() {
        return NAME;
    }

    public void setAliasService(AliasService as) {
        this.as = as;
    }

    public void initializeContribution(DeploymentContext context) {
        super.initializeContribution(context);
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        String clusterName = context.getTopology().getName();
        List aliases = new ArrayList();
        try {
            aliases = this.as.getAliasesForCluster(clusterName);
        }
        catch (AliasServiceException e) {
            log.aliasServiceException((Exception)((Object)e));
        }
        if (params == null) {
            params = new ArrayList<FilterParamDescriptor>();
        }
        Map providerParams = provider.getParams();
        for (Map.Entry entry : providerParams.entrySet()) {
            String key = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
            String value = null;
            if (aliases.contains(key)) {
                try {
                    value = String.valueOf(this.as.getPasswordFromAliasForCluster(clusterName, key));
                }
                catch (AliasServiceException e) {
                    log.unableToGetPassword(key, (Exception)((Object)e));
                }
            } else {
                value = (String)entry.getValue();
            }
            params.add(resource.createFilterParam().name(key).value(value));
        }
        resource.addFilter().name(this.getName()).role(this.getRole()).impl(HADOOPAUTH_FILTER_CLASSNAME).params(params);
        resource.addFilter().name("Post" + this.getName()).role(this.getRole()).impl(HADOOPAUTH_POSTFILTER_CLASSNAME).params(params);
    }
}

