/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.MasterService;
import org.apache.knox.gateway.services.security.SSLService;
import org.apache.knox.gateway.util.X500PrincipalParser;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettySSLService
implements SSLService {
    private static final String EPHEMERAL_DH_KEY_SIZE_PROPERTY = "jdk.tls.ephemeralDHKeySize";
    private static final String GATEWAY_TRUSTSTORE_PASSWORD = "gateway-truststore-password";
    private static final String GATEWAY_CREDENTIAL_STORE_NAME = "__gateway";
    private static GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private MasterService ms;
    private KeystoreService ks;
    private AliasService as;
    private List<String> sslIncludeCiphers = null;
    private List<String> sslExcludeCiphers = null;
    private List<String> sslExcludeProtocols = null;
    private boolean clientAuthNeeded;
    private boolean trustAllCerts;
    private String truststorePath;
    private String keystoreType;
    private String trustStoreType;
    private boolean clientAuthWanted;

    public void setMasterService(MasterService ms) {
        this.ms = ms;
    }

    public void setAliasService(AliasService as) {
        this.as = as;
    }

    public void setKeystoreService(KeystoreService ks) {
        this.ks = ks;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        System.setProperty(EPHEMERAL_DH_KEY_SIZE_PROPERTY, config.getEphemeralDHKeySize());
        try {
            if (!this.ks.isCredentialStoreForClusterAvailable(GATEWAY_CREDENTIAL_STORE_NAME)) {
                log.creatingCredentialStoreForGateway();
                this.ks.createCredentialStoreForCluster(GATEWAY_CREDENTIAL_STORE_NAME);
            } else {
                log.credentialStoreForGatewayFoundNotCreating();
            }
        }
        catch (KeystoreServiceException e) {
            throw new ServiceLifecycleException("Keystore was not loaded properly - the provided (or persisted) master secret may not match the password for the keystore.", (Exception)((Object)e));
        }
        try {
            if (!this.ks.isKeystoreForGatewayAvailable()) {
                log.creatingKeyStoreForGateway();
                this.ks.createKeystoreForGateway();
                char[] passphrase = null;
                try {
                    passphrase = this.as.getGatewayIdentityPassphrase();
                }
                catch (AliasServiceException e) {
                    throw new ServiceLifecycleException("Error accessing credential store for the gateway.", (Exception)((Object)e));
                }
                if (passphrase == null) {
                    passphrase = this.ms.getMasterSecret();
                }
                this.ks.addSelfSignedCertForGateway("gateway-identity", passphrase);
            } else {
                log.keyStoreForGatewayFoundNotCreating();
            }
            this.logAndValidateCertificate();
        }
        catch (KeystoreServiceException e) {
            throw new ServiceLifecycleException("Keystore was not loaded properly - the provided (or persisted) master secret may not match the password for the keystore.", (Exception)((Object)e));
        }
        this.keystoreType = config.getKeystoreType();
        this.sslIncludeCiphers = config.getIncludedSSLCiphers();
        this.sslExcludeCiphers = config.getExcludedSSLCiphers();
        this.sslExcludeProtocols = config.getExcludedSSLProtocols();
        this.clientAuthNeeded = config.isClientAuthNeeded();
        this.clientAuthWanted = config.isClientAuthWanted();
        this.truststorePath = config.getTruststorePath();
        this.trustAllCerts = config.getTrustAllCerts();
        this.trustStoreType = config.getTruststoreType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logAndValidateCertificate() throws ServiceLifecycleException {
        Certificate cert;
        try {
            cert = this.as.getCertificateForGateway("gateway-identity");
        }
        catch (AliasServiceException e) {
            throw new ServiceLifecycleException("Cannot Retreive Gateway SSL Certificate. Server will not start.", (Exception)((Object)e));
        }
        if (cert == null) throw new ServiceLifecycleException("Public certificate for the gateway is not of the expected type of X509Certificate. Something is wrong with the gateway keystore.");
        if (!(cert instanceof X509Certificate)) throw new ServiceLifecycleException("Public certificate for the gateway cannot be found with the alias gateway-identity. Plase check the identity certificate alias.");
        X500Principal x500Principal = ((X509Certificate)cert).getSubjectX500Principal();
        X500PrincipalParser parser = new X500PrincipalParser(x500Principal);
        log.certificateHostNameForGateway(parser.getCN());
        Date notBefore = ((X509Certificate)cert).getNotBefore();
        Date notAfter = ((X509Certificate)cert).getNotAfter();
        log.certificateValidityPeriod(notBefore, notAfter);
        try {
            ((X509Certificate)cert).checkValidity();
            return;
        }
        catch (CertificateExpiredException e) {
            throw new ServiceLifecycleException("Gateway SSL Certificate is Expired. Server will not start.", (Exception)e);
        }
        catch (CertificateNotYetValidException e) {
            throw new ServiceLifecycleException("Gateway SSL Certificate is not yet valid. Server will not start.", (Exception)e);
        }
    }

    public Object buildSslContextFactory(String keystoreFileName) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        SslContextFactory sslContextFactory = new SslContextFactory(true);
        sslContextFactory.setCertAlias("gateway-identity");
        sslContextFactory.setKeyStoreType(this.keystoreType);
        sslContextFactory.setKeyStorePath(keystoreFileName);
        char[] master = this.ms.getMasterSecret();
        sslContextFactory.setKeyStorePassword(new String(master));
        char[] keypass = null;
        try {
            keypass = this.as.getGatewayIdentityPassphrase();
        }
        catch (AliasServiceException aliasServiceException) {
            // empty catch block
        }
        if (keypass == null) {
            keypass = master;
        }
        sslContextFactory.setKeyManagerPassword(new String(keypass));
        String truststorePassword = null;
        if (this.clientAuthNeeded || this.clientAuthWanted) {
            if (this.truststorePath != null) {
                char[] truststorePwd = null;
                try {
                    truststorePwd = this.as.getPasswordFromAliasForGateway(GATEWAY_TRUSTSTORE_PASSWORD);
                }
                catch (AliasServiceException aliasServiceException) {
                    // empty catch block
                }
                truststorePassword = truststorePwd != null ? new String(truststorePwd) : new String(master);
                sslContextFactory.setTrustStore(JettySSLService.loadKeyStore(this.truststorePath, this.trustStoreType, truststorePassword.toCharArray()));
                sslContextFactory.setTrustStorePassword(truststorePassword);
                sslContextFactory.setTrustStoreType(this.trustStoreType);
            } else {
                sslContextFactory.setTrustStore(JettySSLService.loadKeyStore(keystoreFileName, this.keystoreType, master));
                sslContextFactory.setTrustStorePassword(new String(master));
                sslContextFactory.setTrustStoreType(this.keystoreType);
            }
        }
        if (this.clientAuthNeeded) {
            sslContextFactory.setNeedClientAuth(this.clientAuthNeeded);
        } else {
            sslContextFactory.setWantClientAuth(this.clientAuthWanted);
        }
        sslContextFactory.setTrustAll(this.trustAllCerts);
        if (this.sslIncludeCiphers != null && !this.sslIncludeCiphers.isEmpty()) {
            sslContextFactory.setIncludeCipherSuites(this.sslIncludeCiphers.toArray(new String[this.sslIncludeCiphers.size()]));
        }
        if (this.sslExcludeCiphers != null && !this.sslExcludeCiphers.isEmpty()) {
            sslContextFactory.setExcludeCipherSuites(this.sslExcludeCiphers.toArray(new String[this.sslExcludeCiphers.size()]));
        }
        if (this.sslExcludeProtocols != null && !this.sslExcludeProtocols.isEmpty()) {
            sslContextFactory.setExcludeProtocols(this.sslExcludeProtocols.toArray(new String[this.sslExcludeProtocols.size()]));
        }
        return sslContextFactory;
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(String fileName, String storeType, char[] storePass) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        KeyStore keystore = KeyStore.getInstance(storeType);
        try (FileInputStream is = new FileInputStream(fileName);){
            keystore.load(is, storePass);
        }
        return keystore;
    }
}

