/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.preauth.filter;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.preauth.filter.PreAuthService;
import org.apache.knox.gateway.preauth.filter.PreAuthValidator;
import org.apache.knox.gateway.security.PrimaryPrincipal;

public abstract class AbstractPreAuthFederationFilter
implements Filter {
    private List<PreAuthValidator> validators = null;
    private FilterConfig filterConfig;
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.validators = PreAuthService.getValidators(filterConfig);
    }

    public List<PreAuthValidator> getValidators() {
        return this.validators;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String principal = this.getPrimaryPrincipal(httpRequest);
        if (principal != null) {
            if (PreAuthService.validate(httpRequest, this.filterConfig, this.validators)) {
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)new PrimaryPrincipal(principal));
                this.addGroupPrincipals(httpRequest, subject.getPrincipals());
                auditService.getContext().setUsername(principal);
                String sourceUri = (String)request.getAttribute("sourceRequestContextUrl");
                auditor.audit("authentication", sourceUri, "uri", "success");
                this.doAs((ServletRequest)httpRequest, response, chain, subject);
            } else {
                ((HttpServletResponse)response).sendError(403, "SSO Validation Failure.");
            }
        } else {
            ((HttpServletResponse)response).sendError(403, "Missing Required Header for PreAuth SSO Federation");
        }
    }

    public void destroy() {
    }

    private void doAs(final ServletRequest request, final ServletResponse response, final FilterChain chain, Subject subject) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    chain.doFilter(request, response);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }

    protected abstract String getPrimaryPrincipal(HttpServletRequest var1);

    protected abstract void addGroupPrincipals(HttpServletRequest var1, Set<Principal> var2);
}

