/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.hostmap.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.knox.gateway.hostmap.api.HostmapFunctionDescriptor;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.hostmap.FileBasedHostMapper;
import org.apache.knox.gateway.services.hostmap.HostMapper;
import org.apache.knox.gateway.services.hostmap.HostMapperService;

public class HostmapFunctionProcessor
implements UrlRewriteFunctionProcessor<HostmapFunctionDescriptor> {
    public static final String DESCRIPTOR_DEFAULT_FILE_NAME = "hostmap.txt";
    public static final String DESCRIPTOR_DEFAULT_LOCATION = "/WEB-INF/hostmap.txt";
    private HostMapperService hostMapperService;
    private HostMapper hostMapper = null;
    private String clusterName;

    public String name() {
        return "hostmap";
    }

    public void initialize(UrlRewriteEnvironment environment, HostmapFunctionDescriptor descriptor) throws Exception {
        URL url = environment.getResource(DESCRIPTOR_DEFAULT_LOCATION);
        this.hostMapper = new FileBasedHostMapper(url);
        this.clusterName = (String)environment.getAttribute("org.apache.knox.gateway.gateway.cluster");
        GatewayServices services = (GatewayServices)environment.getAttribute("org.apache.knox.gateway.gateway.services");
        if (this.clusterName != null && services != null) {
            this.hostMapperService = (HostMapperService)services.getService("HostMappingService");
            if (this.hostMapperService != null) {
                this.hostMapperService.registerHostMapperForCluster(this.clusterName, this.hostMapper);
            }
        }
    }

    public void destroy() throws Exception {
        if (this.hostMapperService != null && this.clusterName != null) {
            this.hostMapperService.removeHostMapperForCluster(this.clusterName);
        }
    }

    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        ArrayList<String> result = null;
        if (parameters != null) {
            result = new ArrayList<String>(parameters.size());
            for (String parameter : parameters) {
                switch (context.getDirection()) {
                    case IN: {
                        parameter = this.hostMapper.resolveInboundHostName(parameter);
                        break;
                    }
                    case OUT: {
                        parameter = this.hostMapper.resolveOutboundHostName(parameter);
                    }
                }
                result.add(parameter);
            }
        }
        return result;
    }
}

