/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.crypto.AlgorithmSupportMessage;
import com.nimbusds.jose.crypto.ContentCryptoProvider;
import com.nimbusds.jose.crypto.RSA1_5;
import com.nimbusds.jose.crypto.RSACryptoProvider;
import com.nimbusds.jose.crypto.RSA_OAEP;
import com.nimbusds.jose.crypto.RSA_OAEP_256;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSAEncrypter
extends RSACryptoProvider
implements JWEEncrypter {
    private final RSAPublicKey publicKey;
    private final SecretKey contentEncryptionKey;

    public RSAEncrypter(RSAPublicKey publicKey) {
        this(publicKey, null);
    }

    public RSAEncrypter(RSAKey rsaJWK) throws JOSEException {
        this(rsaJWK.toRSAPublicKey());
    }

    public RSAEncrypter(RSAPublicKey publicKey, SecretKey contentEncryptionKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = publicKey;
        if (contentEncryptionKey != null) {
            if (contentEncryptionKey.getAlgorithm() == null || !contentEncryptionKey.getAlgorithm().equals("AES")) {
                throw new IllegalArgumentException("The algorithm of the content encryption key (CEK) must be AES");
            }
            this.contentEncryptionKey = contentEncryptionKey;
        } else {
            this.contentEncryptionKey = null;
        }
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        Base64URL encryptedKey;
        JWEAlgorithm alg = header.getAlgorithm();
        EncryptionMethod enc = header.getEncryptionMethod();
        SecretKey cek = this.contentEncryptionKey != null ? this.contentEncryptionKey : ContentCryptoProvider.generateCEK(enc, this.getJCAContext().getSecureRandom());
        if (alg.equals(JWEAlgorithm.RSA1_5)) {
            encryptedKey = Base64URL.encode(RSA1_5.encryptCEK(this.publicKey, cek, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP)) {
            encryptedKey = Base64URL.encode(RSA_OAEP.encryptCEK(this.publicKey, cek, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP_256)) {
            encryptedKey = Base64URL.encode(RSA_OAEP_256.encryptCEK(this.publicKey, cek, this.getJCAContext().getKeyEncryptionProvider()));
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.encrypt(header, clearText, cek, encryptedKey, this.getJCAContext());
    }
}

