/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CompositeEnumeration<T>
implements Enumeration<T> {
    private int index = 0;
    private Enumeration<T>[] array;

    public CompositeEnumeration(Enumeration<T> ... enumerations) {
        if (enumerations == null) {
            throw new IllegalArgumentException("enumerations==null");
        }
        this.array = enumerations;
    }

    @Override
    public boolean hasMoreElements() {
        while (this.array.length > 0 && this.index < this.array.length) {
            if (this.array[this.index].hasMoreElements()) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    @Override
    public T nextElement() {
        if (this.hasMoreElements()) {
            return this.array[this.index].nextElement();
        }
        throw new NoSuchElementException();
    }
}

