/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.proxiedauthz;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.controls.ProxiedAuthz;
import org.apache.directory.api.ldap.model.message.controls.ProxiedAuthzImpl;
import org.apache.directory.api.util.Strings;

public class ProxiedAuthzDecorator
extends ControlDecorator<ProxiedAuthz>
implements ProxiedAuthz {
    private byte[] authzIdBytes = null;

    public ProxiedAuthzDecorator(LdapApiService codec) {
        super(codec, new ProxiedAuthzImpl());
    }

    public ProxiedAuthzDecorator(LdapApiService codec, ProxiedAuthz control) {
        super(codec, control);
    }

    private ProxiedAuthz getProxiedAuthz() {
        return (ProxiedAuthz)this.getDecorated();
    }

    @Override
    public int computeLength() {
        int valueLength = 0;
        if (this.getAuthzId() != null) {
            this.authzIdBytes = Strings.getBytesUtf8(this.getAuthzId());
            valueLength = this.authzIdBytes.length;
        }
        return valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        if (this.getAuthzId() != null) {
            buffer.put(this.authzIdBytes);
        }
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                if (this.authzIdBytes != null) {
                    BerValue.encode(buffer, this.authzIdBytes);
                } else {
                    BerValue.encode(buffer, Strings.EMPTY_BYTES);
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public String getAuthzId() {
        return this.getProxiedAuthz().getAuthzId();
    }

    @Override
    public void setAuthzId(String authzId) {
        this.getProxiedAuthz().setAuthzId(authzId);
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        this.getProxiedAuthz().setAuthzId(Strings.utf8ToString(controlBytes));
        return this;
    }
}

