/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLayout {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLayout.class);
    private File[] requiredDirectories = new File[0];
    private File[] requiredFiles = new File[0];
    private File directory;

    protected AbstractLayout(File directory) {
        this.directory = directory;
    }

    protected AbstractLayout(String directoryPath) {
        this.directory = new File(directoryPath);
    }

    protected File getDirectory() {
        return this.directory;
    }

    public File[] getRequiredDirectories() {
        return this.requiredDirectories;
    }

    public File[] getRequiredFiles() {
        return this.requiredFiles;
    }

    public void mkdirs() throws IOException {
        for (File requiredDirectory : this.requiredDirectories) {
            if (requiredDirectory.exists() || requiredDirectory.mkdirs()) continue;
            throw new IOException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, requiredDirectory));
        }
    }

    protected void setRequiredDirectories(File[] requiredDirectories) {
        this.requiredDirectories = requiredDirectories;
    }

    protected void setRequiredFiles(File[] requiredFiles) {
        this.requiredFiles = requiredFiles;
    }

    public void verifyInstallation() {
        LOG.debug("Verifying required directories");
        for (File requiredDirectory : this.requiredDirectories) {
            if (!requiredDirectory.exists()) {
                String message = "The required '" + requiredDirectory + " directory does not exist!";
                LOG.error(message);
                throw new IllegalStateException(message);
            }
            if (requiredDirectory.isFile()) {
                String message = "'" + requiredDirectory + "' is a file when it should be a directory.";
                LOG.error(message);
                throw new IllegalStateException(message);
            }
            if (requiredDirectory.canWrite()) continue;
            String message = "'" + requiredDirectory + "' is write protected from the current user '" + System.getProperty("user.name") + "'";
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        LOG.debug("Required directories verification finished successfully.");
        LOG.debug("Verifying required files");
        for (File requiredFile : this.requiredFiles) {
            if (!requiredFile.exists()) {
                String message = "The required'" + requiredFile + "' file does not exist!";
                LOG.error(message);
                throw new IllegalStateException(message);
            }
            if (requiredFile.isDirectory()) {
                String message = "'" + requiredFile + "' is a directory when it should be a file.";
                LOG.error(message);
                throw new IllegalStateException(message);
            }
            if (requiredFile.canRead()) continue;
            String message = "'" + requiredFile + "' is not readable by the current user '" + System.getProperty("user.name") + "'.";
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        LOG.debug("Required files verification finished successfully.");
    }
}

