/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.filtering;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursorList
extends AbstractCursor<Entry>
implements EntryFilteringCursor {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final List<EntryFilteringCursor> list;
    private final int start;
    private final int end;
    private final int listSize;
    private int index;
    private EntryFilteringCursor currentCursor;
    private SearchOperationContext searchContext;
    private boolean closed;
    private static final Logger LOG = LoggerFactory.getLogger(CursorList.class);

    public CursorList(int start, List<EntryFilteringCursor> list, int end, SearchOperationContext searchContext) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating CursorList {}", (Object)this);
        }
        this.list = list != null ? list : Collections.emptyList();
        this.listSize = this.list.size();
        if (start < 0 || start > this.listSize) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_02005_START_INDEX_OUT_OF_RANGE, start));
        }
        if (end < 0 || end > this.listSize) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_02006_END_INDEX_OUT_OF_RANGE, end));
        }
        if (this.listSize > 0 && start >= end) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_02007_START_INDEX_ABOVE_END_INDEX, start, end));
        }
        this.start = start;
        this.end = end;
        this.searchContext = searchContext;
        this.index = start;
        this.currentCursor = this.list.get(this.index);
    }

    public CursorList(List<EntryFilteringCursor> list, SearchOperationContext searchContext) {
        this(0, list, list.size(), searchContext);
    }

    @Override
    public boolean available() {
        if (this.index >= 0 && this.index < this.end) {
            return this.list.get(this.index).available();
        }
        return false;
    }

    @Override
    public void before(Entry element) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02008_LIST_MAY_BE_SORTED, new Object[0]));
    }

    @Override
    public void after(Entry element) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02008_LIST_MAY_BE_SORTED, new Object[0]));
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.index = 0;
        this.currentCursor = this.list.get(this.index);
        this.currentCursor.beforeFirst();
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.index = this.end - 1;
        this.currentCursor = this.list.get(this.index);
        this.currentCursor.afterLast();
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        if (this.listSize > 0) {
            this.index = this.start;
            return this.list.get(this.index).first();
        }
        return false;
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        if (this.listSize > 0) {
            this.index = this.end - 1;
            this.currentCursor = this.list.get(this.index);
            return this.currentCursor.last();
        }
        return false;
    }

    @Override
    public boolean isFirst() {
        return this.listSize > 0 && this.index == this.start && this.list.get(this.index).isFirst();
    }

    @Override
    public boolean isLast() {
        return this.listSize > 0 && this.index == this.end - 1 && this.list.get(this.index).isLast();
    }

    @Override
    public boolean isAfterLast() {
        return this.index == this.end;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.index == -1;
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        while (this.index > -1) {
            this.currentCursor = this.list.get(this.index);
            if (this.currentCursor.previous()) {
                return true;
            }
            --this.index;
        }
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        if (this.listSize > 0) {
            if (this.index == -1) {
                this.index = this.start;
            }
            while (this.index < this.end) {
                this.currentCursor = this.list.get(this.index);
                if (this.currentCursor.next()) {
                    return true;
                }
                ++this.index;
            }
        }
        return false;
    }

    @Override
    public Entry get() throws CursorException {
        if (this.index < this.start || this.index >= this.end) {
            throw new CursorException(I18n.err(I18n.ERR_02009_CURSOR_NOT_POSITIONED, new Object[0]));
        }
        if (this.currentCursor.available()) {
            return (Entry)this.currentCursor.get();
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean addEntryFilter(EntryFilter filter) {
        for (EntryFilteringCursor efc : this.list) {
            efc.addEntryFilter(filter);
        }
        return true;
    }

    @Override
    public List<EntryFilter> getEntryFilters() {
        throw new UnsupportedOperationException("CursorList doesn't support this operation");
    }

    @Override
    public SearchOperationContext getOperationContext() {
        return this.searchContext;
    }

    public boolean isAbandoned() {
        return this.searchContext.isAbandoned();
    }

    public void setAbandoned(boolean abandoned) {
        this.searchContext.setAbandoned(abandoned);
        if (abandoned) {
            LOG.info("Cursor has been abandoned.");
        }
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing CursorList {}", (Object)this);
        }
        this.close(null);
    }

    @Override
    public void close(Exception reason) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing CursorList {}", (Object)this);
        }
        this.closed = true;
        for (EntryFilteringCursor cursor : this.list) {
            try {
                if (reason != null) {
                    cursor.close(reason);
                    continue;
                }
                cursor.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close the cursor");
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Iterator<Entry> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClosureMonitor(ClosureMonitor monitor) {
        for (EntryFilteringCursor c : this.list) {
            c.setClosureMonitor(monitor);
        }
    }
}

