/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.descriptor.xml;

import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.FactoryCreateRule;
import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.binder.AbstractRulesModule;
import org.apache.knox.gateway.descriptor.xml.XmlGatewayDescriptorFactory;
import org.apache.knox.gateway.descriptor.xml.XmlGatewayDescriptorTags;
import org.xml.sax.Attributes;

public class XmlGatewayDescriptorRules
extends AbstractRulesModule
implements XmlGatewayDescriptorTags {
    private static final Object[] NO_PARAMS = new Object[0];

    protected void configure() {
        this.forPattern("gateway").addRule((Rule)new FactoryCreateRule(XmlGatewayDescriptorFactory.class));
        this.forPattern("gateway/resource").addRule((Rule)new AddNextRule("addResource"));
        this.forPattern("gateway/resource/role").callMethod("role").usingElementBodyAsArgument();
        this.forPattern("gateway/resource/pattern").callMethod("pattern").usingElementBodyAsArgument();
        this.forPattern("gateway/resource/filter").addRule((Rule)new AddNextRule("addFilter"));
        this.forPattern("gateway/resource/filter/role").callMethod("name").usingElementBodyAsArgument();
        this.forPattern("gateway/resource/filter/role").callMethod("role").usingElementBodyAsArgument();
        this.forPattern("gateway/resource/filter/class").callMethod("impl").usingElementBodyAsArgument();
        this.forPattern("gateway/resource/filter/param").addRule((Rule)new AddNextRule("param"));
        this.forPattern("gateway/resource/filter/param/name").callMethod("name").usingElementBodyAsArgument();
        this.forPattern("gateway/resource/filter/param/value").callMethod("value").usingElementBodyAsArgument();
    }

    private static class AddNextRule
    extends Rule {
        private String method;

        private AddNextRule(String method) {
            this.method = method;
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            Digester digester = this.getDigester();
            digester.push(MethodUtils.invokeMethod((Object)digester.peek(), (String)this.method, (Object[])NO_PARAMS));
        }

        public void end(String namespace, String name) {
            this.getDigester().pop();
        }
    }
}

