/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClient;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.EncryptionResult;
import org.apache.knox.gateway.services.security.MasterService;
import org.apache.knox.gateway.services.security.impl.ConfigurableEncryptor;
import org.apache.knox.gateway.services.security.impl.DefaultAliasService;

public class RemoteAliasService
implements AliasService {
    public static final String PATH_KNOX = "/knox";
    public static final String PATH_KNOX_SECURITY = "/knox/security";
    public static final String PATH_KNOX_ALIAS_STORE_TOPOLOGY = "/knox/security/topology";
    public static final String PATH_SEPARATOR = "/";
    public static final String DEFAULT_CLUSTER_NAME = "__gateway";
    public static final String GATEWAY_IDENTITY_PASSPHRASE = "gateway-identity-passphrase";
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final RemoteConfigurationRegistryClient.EntryACL AUTHENTICATED_USERS_ALL = new RemoteConfigurationRegistryClient.EntryACL(){

        public String getId() {
            return "";
        }

        public String getType() {
            return "auth";
        }

        public Object getPermissions() {
            return 31;
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }
    };
    private RemoteConfigurationRegistryClient remoteClient;
    private ConfigurableEncryptor encryptor;
    private AliasService localAliasService;
    private RemoteConfigurationRegistryClientService registryClientService;
    private MasterService ms;
    private GatewayConfig config;
    private Map<String, String> options;

    private static String buildAliasEntryName(String clusterName, String alias) {
        return RemoteAliasService.buildClusterEntryName(clusterName) + PATH_SEPARATOR + alias;
    }

    private static String buildClusterEntryName(String clusterName) {
        return "/knox/security/topology/" + clusterName;
    }

    private static void ensureEntry(String path, RemoteConfigurationRegistryClient remoteClient) {
        if (!remoteClient.entryExists(path)) {
            remoteClient.createEntry(path);
        } else {
            List entryACLs = remoteClient.getACL(path);
            for (RemoteConfigurationRegistryClient.EntryACL entryACL : entryACLs) {
                if (!entryACL.getType().equals("world") || !entryACL.getId().equals("anyone")) continue;
                LOG.suspectWritableRemoteConfigurationEntry(path);
                if (!remoteClient.isAuthenticationConfigured()) continue;
                LOG.correctingSuspectWritableRemoteConfigurationEntry(path);
                remoteClient.setACL(path, Collections.singletonList(AUTHENTICATED_USERS_ALL));
            }
        }
    }

    private static void checkPathsExist(RemoteConfigurationRegistryClient remoteClient) {
        RemoteAliasService.ensureEntry(PATH_KNOX, remoteClient);
        RemoteAliasService.ensureEntry(PATH_KNOX_SECURITY, remoteClient);
        RemoteAliasService.ensureEntry(PATH_KNOX_ALIAS_STORE_TOPOLOGY, remoteClient);
        RemoteAliasService.ensureEntry("/knox/security/topology/__gateway", remoteClient);
    }

    private static List<String> safe(List<String> given) {
        return given == null ? Collections.EMPTY_LIST : given;
    }

    public void setRegistryClientService(RemoteConfigurationRegistryClientService registryClientService) {
        this.registryClientService = registryClientService;
    }

    public void setMasterService(MasterService ms) {
        this.ms = ms;
    }

    public void setLocalAliasService(AliasService localAliasService) {
        this.localAliasService = localAliasService;
    }

    public List<String> getAliasesForCluster(String clusterName) throws AliasServiceException {
        ArrayList<String> remoteAliases = new ArrayList();
        if (this.remoteClient != null && this.config.isRemoteAliasServiceEnabled()) {
            remoteAliases = this.remoteClient.listChildEntries(RemoteAliasService.buildClusterEntryName(clusterName));
        }
        List localAliases = this.localAliasService.getAliasesForCluster(clusterName);
        for (String alias : RemoteAliasService.safe(localAliases)) {
            if (remoteAliases.contains(alias.toLowerCase(Locale.ROOT))) continue;
            remoteAliases.add(alias);
        }
        return remoteAliases;
    }

    public void addAliasForCluster(String clusterName, String givenAlias, String value) throws AliasServiceException {
        String alias = givenAlias.toLowerCase(Locale.ROOT);
        this.localAliasService.addAliasForCluster(clusterName, alias, value);
        if (this.remoteClient != null && this.config.isRemoteAliasServiceEnabled()) {
            String aliasEntryPath = RemoteAliasService.buildAliasEntryName(clusterName, alias);
            RemoteAliasService.checkPathsExist(this.remoteClient);
            RemoteAliasService.ensureEntry(RemoteAliasService.buildClusterEntryName(clusterName), this.remoteClient);
            try {
                this.remoteClient.createEntry(aliasEntryPath, this.encrypt(value));
            }
            catch (Exception e) {
                throw new AliasServiceException(e);
            }
            if (this.remoteClient.getEntryData(aliasEntryPath) == null) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Failed to store alias %s for cluster %s in remote registry", alias, clusterName));
            }
        }
    }

    public void removeAliasForCluster(String clusterName, String givenAlias) throws AliasServiceException {
        String alias = givenAlias.toLowerCase(Locale.ROOT);
        this.localAliasService.removeAliasForCluster(clusterName, alias);
        if (this.remoteClient != null && this.config.isRemoteAliasServiceEnabled()) {
            String aliasEntryPath = RemoteAliasService.buildAliasEntryName(clusterName, alias);
            if (this.remoteClient.entryExists(aliasEntryPath)) {
                this.remoteClient.deleteEntry(aliasEntryPath);
                if (this.remoteClient.entryExists(aliasEntryPath)) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Failed to delete alias %s for cluster %s in remote registry", alias, clusterName));
                }
            }
        } else {
            LOG.missingClientConfigurationForRemoteMonitoring();
        }
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster(clusterName, alias, false);
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String givenAlias, boolean generate) throws AliasServiceException {
        String alias = givenAlias.toLowerCase(Locale.ROOT);
        char[] password = null;
        if (this.remoteClient != null && this.config.isRemoteAliasServiceEnabled()) {
            RemoteAliasService.checkPathsExist(this.remoteClient);
            String encrypted = null;
            if (this.remoteClient.entryExists(RemoteAliasService.buildAliasEntryName(clusterName, alias))) {
                encrypted = this.remoteClient.getEntryData(RemoteAliasService.buildAliasEntryName(clusterName, alias));
            }
            if (encrypted == null) {
                if (generate) {
                    this.generateAliasForCluster(clusterName, alias);
                    password = this.getPasswordFromAliasForCluster(clusterName, alias);
                }
            } else {
                try {
                    password = this.decrypt(encrypted).toCharArray();
                }
                catch (Exception e) {
                    throw new AliasServiceException(e);
                }
            }
        }
        if (password == null) {
            password = this.localAliasService.getPasswordFromAliasForCluster(clusterName, alias, generate);
        }
        return password;
    }

    public void generateAliasForCluster(String clusterName, String givenAlias) throws AliasServiceException {
        String alias = givenAlias.toLowerCase(Locale.ROOT);
        String passwordString = DefaultAliasService.generatePassword(16);
        this.addAliasForCluster(clusterName, alias, passwordString);
    }

    public char[] getPasswordFromAliasForGateway(String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster(DEFAULT_CLUSTER_NAME, alias);
    }

    public char[] getGatewayIdentityPassphrase() throws AliasServiceException {
        char[] passphrase = this.getPasswordFromAliasForGateway(GATEWAY_IDENTITY_PASSPHRASE);
        if (passphrase == null) {
            passphrase = this.ms.getMasterSecret();
        }
        return passphrase;
    }

    public void generateAliasForGateway(String alias) throws AliasServiceException {
        this.generateAliasForCluster(DEFAULT_CLUSTER_NAME, alias);
    }

    public Certificate getCertificateForGateway(String alias) throws AliasServiceException {
        return this.localAliasService.getCertificateForGateway(alias);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.config = config;
        this.options = options;
        this.encryptor = new ConfigurableEncryptor(new String(this.ms.getMasterSecret()));
        this.encryptor.init(config);
        String clientName = config.getRemoteConfigurationMonitorClientName();
        if (clientName != null) {
            if (this.registryClientService == null) throw new ServiceLifecycleException("Remote configuration registry not initialized");
            this.remoteClient = this.registryClientService.get(clientName);
            return;
        } else {
            LOG.missingClientConfigurationForRemoteMonitoring();
        }
    }

    public void start() throws ServiceLifecycleException {
        if (this.remoteClient != null && this.config.isRemoteAliasServiceEnabled()) {
            this.ensureEntries(this.remoteClient);
            List aliases = this.remoteClient.listChildEntries(PATH_KNOX_ALIAS_STORE_TOPOLOGY);
            if (aliases == null) {
                throw new IllegalStateException("Unable to access remote path: /knox/security/topology");
            }
            try {
                this.remoteClient.addChildEntryListener(PATH_KNOX_ALIAS_STORE_TOPOLOGY, (RemoteConfigurationRegistryClient.ChildEntryListener)new RemoteAliasChildListener(this));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to add listener for path /knox/security/topology", e);
            }
        }
        if (!this.config.isRemoteAliasServiceEnabled()) {
            LOG.remoteAliasServiceDisabled();
        } else {
            LOG.remoteAliasServiceEnabled();
        }
    }

    public void stop() throws ServiceLifecycleException {
        if (this.remoteClient != null && this.config.isRemoteAliasServiceEnabled()) {
            try {
                this.remoteClient.removeEntryListener(PATH_KNOX_ALIAS_STORE_TOPOLOGY);
            }
            catch (Exception e) {
                LOG.errorRemovingRemoteListener(PATH_KNOX_ALIAS_STORE_TOPOLOGY, e.toString());
            }
        }
    }

    public void addAliasForClusterLocally(String clusterName, String alias, String value) throws AliasServiceException {
        this.localAliasService.addAliasForCluster(clusterName, alias, value);
    }

    public void removeAliasForClusterLocally(String clusterName, String alias) throws AliasServiceException {
        LOG.removeAliasLocally(clusterName, alias);
        this.localAliasService.removeAliasForCluster(clusterName, alias);
    }

    private void ensureEntries(RemoteConfigurationRegistryClient remoteClient) {
        RemoteAliasService.ensureEntry(PATH_KNOX, remoteClient);
        RemoteAliasService.ensureEntry(PATH_KNOX_SECURITY, remoteClient);
        RemoteAliasService.ensureEntry(PATH_KNOX_ALIAS_STORE_TOPOLOGY, remoteClient);
        RemoteAliasService.ensureEntry("/knox/security/topology/__gateway", remoteClient);
    }

    public String encrypt(String clear) throws Exception {
        EncryptionResult result = this.encryptor.encrypt(clear);
        return Base64.encodeBase64String((byte[])(Base64.encodeBase64String((byte[])result.salt) + "::" + Base64.encodeBase64String((byte[])result.iv) + "::" + Base64.encodeBase64String((byte[])result.cipher)).getBytes(StandardCharsets.UTF_8));
    }

    public String decrypt(String encoded) throws Exception {
        String line = new String(Base64.decodeBase64((String)encoded), StandardCharsets.UTF_8);
        String[] parts = line.split("::");
        return new String(this.encryptor.decrypt(Base64.decodeBase64((String)parts[0]), Base64.decodeBase64((String)parts[1]), Base64.decodeBase64((String)parts[2])), StandardCharsets.UTF_8);
    }

    private static class RemoteAliasEntryListener
    implements RemoteConfigurationRegistryClient.EntryListener {
        final String cluster;
        final String alias;
        final RemoteAliasService remoteAliasService;

        public RemoteAliasEntryListener(String cluster, String alias, RemoteAliasService remoteAliasService) {
            this.cluster = cluster;
            this.alias = alias;
            this.remoteAliasService = remoteAliasService;
        }

        public void entryChanged(RemoteConfigurationRegistryClient client, String path, byte[] data) {
            AliasService aliasService;
            if (GatewayServer.getGatewayServices() != null && (aliasService = (AliasService)GatewayServer.getGatewayServices().getService("AliasService")) != null && aliasService instanceof RemoteAliasService) {
                try {
                    ((RemoteAliasService)aliasService).addAliasForClusterLocally(this.cluster, this.alias, this.remoteAliasService.decrypt(new String(data, StandardCharsets.UTF_8)));
                }
                catch (Exception e) {
                    LOG.errorAddingAliasLocally(this.cluster, this.alias, e.toString());
                }
            }
        }
    }

    private class RemoteAliasChildListener
    implements RemoteConfigurationRegistryClient.ChildEntryListener {
        final RemoteAliasService remoteAliasService;

        public RemoteAliasChildListener(RemoteAliasService remoteAliasService2) {
            this.remoteAliasService = remoteAliasService2;
        }

        public void childEvent(RemoteConfigurationRegistryClient client, RemoteConfigurationRegistryClient.ChildEntryListener.Type type, String path) {
            String subPath = StringUtils.substringAfter((String)path, (String)"/knox/security/topology/");
            String[] paths = StringUtils.split((String)subPath, (char)'/');
            switch (type) {
                case REMOVED: {
                    try {
                        AliasService aliasService;
                        client.removeEntryListener(path);
                        if (GatewayServer.getGatewayServices() == null || (aliasService = (AliasService)GatewayServer.getGatewayServices().getService("AliasService")) == null || paths.length <= 1 || !(aliasService instanceof RemoteAliasService)) break;
                        ((RemoteAliasService)aliasService).removeAliasForClusterLocally(paths[0], paths[1]);
                    }
                    catch (Exception e) {
                        LOG.errorRemovingAliasLocally(paths[0], paths[1], e.toString());
                    }
                    break;
                }
                case ADDED: {
                    if (paths.length > 1) {
                        LOG.addAliasLocally(paths[0], paths[1]);
                        try {
                            client.addEntryListener(path, (RemoteConfigurationRegistryClient.EntryListener)new RemoteAliasEntryListener(paths[0], paths[1], this.remoteAliasService));
                        }
                        catch (Exception e) {
                            LOG.errorRemovingAliasLocally(paths[0], paths[1], e.toString());
                        }
                        break;
                    }
                    if (subPath == null) break;
                    LOG.addRemoteListener(path);
                    try {
                        client.addChildEntryListener(path, (RemoteConfigurationRegistryClient.ChildEntryListener)new RemoteAliasChildListener(this.remoteAliasService));
                        break;
                    }
                    catch (Exception e) {
                        LOG.errorAddingRemoteListener(path, e.toString());
                    }
                }
            }
        }
    }
}

