/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;

public class DefaultTokenAuthorityService
implements JWTokenAuthority,
Service {
    private static final String SIGNING_KEY_PASSPHRASE = "signing.key.passphrase";
    private static final Set<String> SUPPORTED_SIG_ALGS = new HashSet<String>();
    private AliasService as = null;
    private KeystoreService ks = null;
    String signingKeyAlias = null;

    public void setKeystoreService(KeystoreService ks) {
        this.ks = ks;
    }

    public void setAliasService(AliasService as) {
        this.as = as;
    }

    public JWT issueToken(Subject subject, String algorithm) throws TokenServiceException {
        Principal p = (Principal)subject.getPrincipals().toArray()[0];
        return this.issueToken(p, algorithm);
    }

    public JWT issueToken(Principal p, String algorithm) throws TokenServiceException {
        return this.issueToken(p, null, algorithm);
    }

    public JWT issueToken(Principal p, String algorithm, long expires) throws TokenServiceException {
        return this.issueToken(p, (String)null, algorithm, expires);
    }

    public JWT issueToken(Principal p, String audience, String algorithm) throws TokenServiceException {
        return this.issueToken(p, audience, algorithm, -1L);
    }

    public JWT issueToken(Principal p, String audience, String algorithm, long expires) throws TokenServiceException {
        ArrayList<String> audiences = null;
        if (audience != null) {
            audiences = new ArrayList<String>();
            audiences.add(audience);
        }
        return this.issueToken(p, audiences, algorithm, expires);
    }

    public JWT issueToken(Principal p, List<String> audiences, String algorithm, long expires) throws TokenServiceException {
        return this.issueToken(p, audiences, algorithm, expires, null, null, null);
    }

    public JWT issueToken(Principal p, List<String> audiences, String algorithm, long expires, String signingKeystoreName, String signingKeystoreAlias, char[] signingKeystorePassphrase) throws TokenServiceException {
        JWTToken token;
        String[] claimArray = new String[]{"KNOXSSO", p.getName(), null, expires == -1L ? null : String.valueOf(expires)};
        if (SUPPORTED_SIG_ALGS.contains(algorithm)) {
            char[] passphrase;
            token = new JWTToken(algorithm, claimArray, audiences);
            try {
                passphrase = this.getSigningKeyPassphrase(signingKeystorePassphrase);
            }
            catch (AliasServiceException e) {
                throw new TokenServiceException((Exception)((Object)e));
            }
            try {
                RSAPrivateKey key = (RSAPrivateKey)this.ks.getSigningKey(signingKeystoreName, this.getSigningKeyAlias(signingKeystoreAlias), passphrase);
                RSASSASigner signer = new RSASSASigner((PrivateKey)key);
                token.sign((JWSSigner)signer);
            }
            catch (KeystoreServiceException e) {
                throw new TokenServiceException((Exception)((Object)e));
            }
        }
        throw new TokenServiceException("Cannot issue token - Unsupported algorithm");
        return token;
    }

    private char[] getSigningKeyPassphrase(char[] signingKeyPassphrase) throws AliasServiceException {
        if (signingKeyPassphrase != null) {
            return signingKeyPassphrase;
        }
        char[] phrase = this.as.getPasswordFromAliasForGateway(SIGNING_KEY_PASSPHRASE);
        if (phrase == null) {
            phrase = this.as.getGatewayIdentityPassphrase();
        }
        return phrase;
    }

    private String getSigningKeyAlias(String signingKeystoreAlias) {
        if (signingKeystoreAlias != null) {
            return signingKeystoreAlias;
        }
        if (this.signingKeyAlias != null) {
            return this.signingKeyAlias;
        }
        return "gateway-identity";
    }

    public boolean verifyToken(JWT token) throws TokenServiceException {
        return this.verifyToken(token, null);
    }

    public boolean verifyToken(JWT token, RSAPublicKey publicKey) throws TokenServiceException {
        boolean rc;
        try {
            PublicKey key = publicKey == null ? this.ks.getSigningKeystore().getCertificate(this.getSigningKeyAlias(this.signingKeyAlias)).getPublicKey() : publicKey;
            RSASSAVerifier verifier = new RSASSAVerifier(key);
            rc = token.verify((JWSVerifier)verifier);
        }
        catch (KeyStoreException | KeystoreServiceException e) {
            throw new TokenServiceException("Cannot verify token.", (Exception)e);
        }
        return rc;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        if (this.as == null || this.ks == null) {
            throw new ServiceLifecycleException("Alias or Keystore service is not set");
        }
        this.signingKeyAlias = config.getSigningKeyAlias();
        try {
            RSAPrivateKey key;
            char[] passphrase = this.as.getPasswordFromAliasForGateway(SIGNING_KEY_PASSPHRASE);
            if (passphrase != null && (key = (RSAPrivateKey)this.ks.getSigningKey(this.getSigningKeyAlias(this.signingKeyAlias), passphrase)) == null) {
                throw new ServiceLifecycleException("Provisioned passphrase cannot be used to acquire signing key.");
            }
        }
        catch (AliasServiceException | KeystoreServiceException e) {
            throw new ServiceLifecycleException("Provisioned signing key passphrase cannot be acquired.", (Exception)e);
        }
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }

    static {
        SUPPORTED_SIG_ALGS.add("RS256");
        SUPPORTED_SIG_ALGS.add("RS384");
        SUPPORTED_SIG_ALGS.add("RS512");
        SUPPORTED_SIG_ALGS.add("PS256");
        SUPPORTED_SIG_ALGS.add("PS384");
        SUPPORTED_SIG_ALGS.add("PS512");
    }
}

