/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.ext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteRuleProcessorHolder;
import org.apache.knox.gateway.util.urltemplate.Matcher;
import org.apache.knox.gateway.util.urltemplate.Template;

public class ScopedMatcher
extends Matcher<UrlRewriteRuleProcessorHolder> {
    public static final String GLOBAL_SCOPE = "GLOBAL";
    private HashMap<String, Matcher<UrlRewriteRuleProcessorHolder>> matchers = new HashMap();

    public UrlRewriteRuleProcessorHolder get(Template template) {
        return (UrlRewriteRuleProcessorHolder)super.get(template);
    }

    public void add(Template template, UrlRewriteRuleProcessorHolder value) {
        Matcher<UrlRewriteRuleProcessorHolder> matcher = this.getMatcher(template, value);
        matcher.add(template, (Object)value);
    }

    public Matcher.Match match(Template input) {
        return this.match(input, null);
    }

    public Matcher.Match match(Template input, String scope) {
        ArrayList<Matcher.Match> matches = new ArrayList<Matcher.Match>();
        for (Matcher<UrlRewriteRuleProcessorHolder> matcher : this.matchers.values()) {
            Matcher.Match match = matcher.match(input);
            if (match == null) continue;
            matches.add(match);
        }
        if (matches.size() == 0) {
            return null;
        }
        if (matches.size() == 1) {
            return this.getMatch(matches, scope);
        }
        return this.findBestMatch(matches, scope);
    }

    private Matcher.Match findBestMatch(List<Matcher.Match> matches, String scope) {
        String matchedScope;
        if (scope != null) {
            for (Matcher.Match match : matches) {
                matchedScope = ((UrlRewriteRuleProcessorHolder)match.getValue()).getScope();
                if (matchedScope == null || !matchedScope.equals(scope)) continue;
                return match;
            }
        }
        for (Matcher.Match match : matches) {
            matchedScope = ((UrlRewriteRuleProcessorHolder)match.getValue()).getScope();
            if (matchedScope == null || !matchedScope.equals(GLOBAL_SCOPE)) continue;
            return match;
        }
        return this.getMatch(matches, scope);
    }

    private Matcher.Match getMatch(List<Matcher.Match> matches, String scope) {
        Matcher.Match match = matches.get(0);
        String matchedScope = ((UrlRewriteRuleProcessorHolder)match.getValue()).getScope();
        if (matchedScope != null && scope != null && !matchedScope.equals(scope) && !matchedScope.equals(GLOBAL_SCOPE)) {
            return null;
        }
        return match;
    }

    private Matcher<UrlRewriteRuleProcessorHolder> getMatcher(Template template, UrlRewriteRuleProcessorHolder holder) {
        String scope = holder.getScope();
        if (!this.matchers.containsKey(scope)) {
            this.matchers.put(scope, (Matcher<UrlRewriteRuleProcessorHolder>)new Matcher());
        }
        return this.matchers.get(scope);
    }
}

