/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.binding.impl.SAMLOutboundDestinationHandler;
import org.opensaml.saml.common.binding.security.impl.EndpointURLSchemeSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLOutboundProtocolMessageSigningHandler;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.sso.SAML2MessageSender;
import org.pac4j.saml.sso.impl.SAML2WebSSOProfileHandler;
import org.pac4j.saml.storage.SAMLMessageStorage;
import org.pac4j.saml.transport.Pac4jHTTPPostEncoder;
import org.pac4j.saml.transport.Pac4jHTTPRedirectDeflateEncoder;
import org.pac4j.saml.transport.Pac4jSAMLResponse;
import org.pac4j.saml.util.VelocityEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2WebSSOMessageSender
implements SAML2MessageSender<AuthnRequest> {
    private static final Logger logger = LoggerFactory.getLogger(SAML2WebSSOProfileHandler.class);
    private final SignatureSigningParametersProvider signatureSigningParametersProvider;
    private final String destinationBindingType;
    private final boolean isAuthnRequestSigned;

    public SAML2WebSSOMessageSender(SignatureSigningParametersProvider signatureSigningParametersProvider, String destinationBindingType, boolean isAuthnRequestSigned) {
        this.signatureSigningParametersProvider = signatureSigningParametersProvider;
        this.destinationBindingType = destinationBindingType;
        this.isAuthnRequestSigned = isAuthnRequestSigned;
    }

    @Override
    public void sendMessage(SAML2MessageContext context, AuthnRequest authnRequest, Object relayState) {
        SPSSODescriptor spDescriptor = context.getSPSSODescriptor();
        IDPSSODescriptor idpssoDescriptor = context.getIDPSSODescriptor();
        SingleSignOnService ssoService = context.getIDPSingleSignOnService(this.destinationBindingType);
        AssertionConsumerService acsService = context.getSPAssertionConsumerService();
        MessageEncoder encoder = this.getMessageEncoder(context);
        SAML2MessageContext outboundContext = new SAML2MessageContext(context);
        outboundContext.getProfileRequestContext().setProfileId(context.getProfileRequestContext().getProfileId());
        outboundContext.getProfileRequestContext().setInboundMessageContext(context.getProfileRequestContext().getInboundMessageContext());
        outboundContext.getProfileRequestContext().setOutboundMessageContext(context.getProfileRequestContext().getOutboundMessageContext());
        outboundContext.setMessage(authnRequest);
        outboundContext.getSAMLEndpointContext().setEndpoint((Endpoint)acsService);
        outboundContext.getSAMLPeerEndpointContext().setEndpoint((Endpoint)ssoService);
        outboundContext.getSAMLPeerEntityContext().setRole(context.getSAMLPeerEntityContext().getRole());
        outboundContext.getSAMLPeerEntityContext().setEntityId(context.getSAMLPeerEntityContext().getEntityId());
        outboundContext.getSAMLProtocolContext().setProtocol(context.getSAMLProtocolContext().getProtocol());
        outboundContext.getSecurityParametersContext().setSignatureSigningParameters(this.signatureSigningParametersProvider.build((SSODescriptor)spDescriptor));
        if (relayState != null) {
            outboundContext.getSAMLBindingContext().setRelayState(relayState.toString());
        }
        try {
            this.invokeOutboundMessageHandlers(spDescriptor, idpssoDescriptor, outboundContext);
            encoder.setMessageContext((MessageContext)outboundContext);
            encoder.initialize();
            encoder.prepareContext();
            encoder.encode();
            SAMLMessageStorage messageStorage = context.getSAMLMessageStorage();
            if (messageStorage != null) {
                messageStorage.storeMessage(authnRequest.getID(), (XMLObject)authnRequest);
            }
        }
        catch (MessageEncodingException e) {
            throw new SAMLException("Error encoding saml message", e);
        }
        catch (ComponentInitializationException e) {
            throw new SAMLException("Error initializing saml encoder", e);
        }
    }

    protected final void invokeOutboundMessageHandlers(SPSSODescriptor spDescriptor, IDPSSODescriptor idpssoDescriptor, SAML2MessageContext outboundContext) {
        try {
            EndpointURLSchemeSecurityHandler handlerEnd = new EndpointURLSchemeSecurityHandler();
            handlerEnd.initialize();
            handlerEnd.invoke((MessageContext)outboundContext);
            SAMLOutboundDestinationHandler handlerDest = new SAMLOutboundDestinationHandler();
            handlerDest.initialize();
            handlerDest.invoke((MessageContext)outboundContext);
            boolean signOutboundContext = false;
            if (this.isAuthnRequestSigned) {
                logger.debug("Authn requests are expected to be always signed before submission");
                signOutboundContext = true;
            } else if (spDescriptor.isAuthnRequestsSigned().booleanValue()) {
                logger.debug("The service provider metadata indicates that authn requests are signed");
                signOutboundContext = true;
            } else if (idpssoDescriptor.getWantAuthnRequestsSigned().booleanValue()) {
                logger.debug("The identity provider metadata indicates that authn requests may be signed");
                signOutboundContext = true;
            }
            if (signOutboundContext) {
                logger.debug("Signing SAML2 outbound context...");
                SAMLOutboundProtocolMessageSigningHandler handler = new SAMLOutboundProtocolMessageSigningHandler();
                handler.invoke((MessageContext)outboundContext);
            }
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    private MessageEncoder getMessageEncoder(SAML2MessageContext ctx) {
        Pac4jSAMLResponse adapter = ctx.getProfileRequestContextOutboundMessageTransportResponse();
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(this.destinationBindingType)) {
            VelocityEngine velocityEngine = VelocityEngineFactory.getEngine();
            Pac4jHTTPPostEncoder encoder = new Pac4jHTTPPostEncoder(adapter);
            encoder.setVelocityEngine(velocityEngine);
            return encoder;
        }
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(this.destinationBindingType)) {
            return new Pac4jHTTPRedirectDeflateEncoder(adapter, this.isAuthnRequestSigned);
        }
        throw new UnsupportedOperationException("Binding type - " + this.destinationBindingType + " is not supported");
    }
}

