/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.manager.ResourceType;

class ListResourcesRequest
extends AbstractRequest<BasicResponse> {
    private ResourceType resourceType = null;

    ListResourcesRequest(KnoxSession session, ResourceType resourceType) {
        super(session);
        this.resourceType = resourceType;
    }

    public List<String> execute() throws Exception {
        return this.parseResourceNames(this.callable().call());
    }

    @Override
    protected Callable<BasicResponse> callable() {
        return () -> {
            URIBuilder uri = this.uri("/admin/api/v1/", this.resourceType.getName());
            HttpGet request = new HttpGet(uri.build());
            request.setHeader("Accept", "application/json");
            return new BasicResponse((HttpResponse)this.execute((HttpRequest)request));
        };
    }

    protected List<String> parseResourceNames(BasicResponse response) throws Exception {
        JSONArray items;
        ArrayList<String> result = new ArrayList<String>();
        JSONObject json = (JSONObject)new JSONParser(0).parse(response.getBytes());
        if (json != null && (items = (JSONArray)json.get((Object)"items")) != null) {
            for (int i = 0; i < items.size(); ++i) {
                JSONObject item = (JSONObject)items.get(i);
                String name = (String)item.get((Object)"name");
                if (name == null) continue;
                result.add(name.substring(0, name.lastIndexOf(".")));
            }
        }
        return result;
    }
}

