/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.extractors;

import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.regex.Pattern;
import org.pac4j.scribe.model.OrcidToken;

public class OrcidJsonExtractor
extends OAuth2AccessTokenJsonExtractor {
    public static final Pattern ORCID_REGEX = Pattern.compile("\"orcid\"\\s*:\\s*\"(\\S*?)\"");

    protected OrcidJsonExtractor() {
    }

    public static OrcidJsonExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    protected OAuth2AccessToken createToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, String response) {
        return new OrcidToken(accessToken, tokenType, expiresIn, refreshToken, scope, OrcidJsonExtractor.extractParameter((String)response, (Pattern)ORCID_REGEX, (boolean)true), response);
    }

    private static class InstanceHolder {
        private static final OrcidJsonExtractor INSTANCE = new OrcidJsonExtractor();

        private InstanceHolder() {
        }
    }
}

