/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.http.ajax.DefaultAjaxRequestResolver;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.QueryParameterCallbackUrlResolver;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.logout.NoLogoutActionBuilder;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.redirect.RedirectActionBuilder;
import org.pac4j.core.util.CommonHelper;

public abstract class IndirectClient<C extends Credentials, U extends CommonProfile>
extends BaseClient<C, U> {
    public static final String ATTEMPTED_AUTHENTICATION_SUFFIX = "$attemptedAuthentication";
    protected String callbackUrl;
    protected UrlResolver urlResolver;
    protected CallbackUrlResolver callbackUrlResolver;
    private AjaxRequestResolver ajaxRequestResolver;
    private RedirectActionBuilder redirectActionBuilder;
    private LogoutActionBuilder<U> logoutActionBuilder = NoLogoutActionBuilder.INSTANCE;

    @Override
    protected final void internalInit() {
        CommonHelper.assertNotBlank("callbackUrl", this.callbackUrl, "set it up either on this IndirectClient or on the global Config");
        if (this.urlResolver == null) {
            this.urlResolver = new DefaultUrlResolver();
        }
        if (this.callbackUrlResolver == null) {
            this.callbackUrlResolver = this.newDefaultCallbackUrlResolver();
        }
        if (this.ajaxRequestResolver == null) {
            this.ajaxRequestResolver = new DefaultAjaxRequestResolver();
        }
        this.clientInit();
        CommonHelper.assertNotNull("redirectActionBuilder", this.redirectActionBuilder);
        CommonHelper.assertNotNull("credentialsExtractor", this.getCredentialsExtractor());
        CommonHelper.assertNotNull("authenticator", this.getAuthenticator());
        CommonHelper.assertNotNull("profileCreator", this.getProfileCreator());
        CommonHelper.assertNotNull("logoutActionBuilder", this.logoutActionBuilder);
    }

    protected CallbackUrlResolver newDefaultCallbackUrlResolver() {
        return new QueryParameterCallbackUrlResolver();
    }

    protected abstract void clientInit();

    @Override
    public final HttpAction redirect(WebContext context) {
        RedirectAction action = this.getRedirectAction(context);
        return action.perform(context);
    }

    public RedirectAction getRedirectAction(WebContext context) {
        this.init();
        if (this.ajaxRequestResolver.isAjax(context)) {
            this.logger.info("AJAX request detected -> returning the appropriate action");
            RedirectAction action = this.redirectActionBuilder.redirect(context);
            this.cleanRequestedUrl(context);
            return this.ajaxRequestResolver.buildAjaxResponse(action.getLocation(), context);
        }
        String attemptedAuth = (String)context.getSessionStore().get(context, this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX);
        if (CommonHelper.isNotBlank(attemptedAuth)) {
            this.cleanAttemptedAuthentication(context);
            this.cleanRequestedUrl(context);
            throw HttpAction.unauthorized(context);
        }
        return this.redirectActionBuilder.redirect(context);
    }

    private void cleanRequestedUrl(WebContext context) {
        SessionStore sessionStore = context.getSessionStore();
        if (sessionStore.get(context, "pac4jRequestedUrl") != null) {
            sessionStore.set(context, "pac4jRequestedUrl", "");
        }
    }

    private void cleanAttemptedAuthentication(WebContext context) {
        SessionStore sessionStore = context.getSessionStore();
        if (sessionStore.get(context, this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX) != null) {
            sessionStore.set(context, this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX, "");
        }
    }

    @Override
    public final C getCredentials(WebContext context) {
        this.init();
        Object credentials = this.retrieveCredentials(context);
        if (credentials == null) {
            context.getSessionStore().set(context, this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX, "true");
        } else {
            this.cleanAttemptedAuthentication(context);
        }
        return credentials;
    }

    @Override
    public final RedirectAction getLogoutAction(WebContext context, U currentProfile, String targetUrl) {
        this.init();
        return this.logoutActionBuilder.getLogoutAction(context, currentProfile, targetUrl);
    }

    public String computeFinalCallbackUrl(WebContext context) {
        return this.callbackUrlResolver.compute(this.urlResolver, this.callbackUrl, this.getName(), context);
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    public void setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
    }

    public CallbackUrlResolver getCallbackUrlResolver() {
        return this.callbackUrlResolver;
    }

    public void setCallbackUrlResolver(CallbackUrlResolver callbackUrlResolver) {
        this.callbackUrlResolver = callbackUrlResolver;
    }

    public AjaxRequestResolver getAjaxRequestResolver() {
        return this.ajaxRequestResolver;
    }

    public void setAjaxRequestResolver(AjaxRequestResolver ajaxRequestResolver) {
        this.ajaxRequestResolver = ajaxRequestResolver;
    }

    public RedirectActionBuilder getRedirectActionBuilder() {
        return this.redirectActionBuilder;
    }

    protected void defaultRedirectActionBuilder(RedirectActionBuilder redirectActionBuilder) {
        if (this.redirectActionBuilder == null) {
            this.redirectActionBuilder = redirectActionBuilder;
        }
    }

    public LogoutActionBuilder<U> getLogoutActionBuilder() {
        return this.logoutActionBuilder;
    }

    protected void defaultLogoutActionBuilder(LogoutActionBuilder<U> logoutActionBuilder) {
        if (this.logoutActionBuilder == null || this.logoutActionBuilder == NoLogoutActionBuilder.INSTANCE) {
            this.logoutActionBuilder = logoutActionBuilder;
        }
    }

    public void setRedirectActionBuilder(RedirectActionBuilder redirectActionBuilder) {
        this.redirectActionBuilder = redirectActionBuilder;
    }

    public void setLogoutActionBuilder(LogoutActionBuilder<U> logoutActionBuilder) {
        this.logoutActionBuilder = logoutActionBuilder;
    }

    @Override
    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "name", this.getName(), "callbackUrl", this.callbackUrl, "urlResolver", this.urlResolver, "callbackUrlResolver", this.callbackUrlResolver, "ajaxRequestResolver", this.ajaxRequestResolver, "redirectActionBuilder", this.redirectActionBuilder, "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "logoutActionBuilder", this.logoutActionBuilder, "authorizationGenerators", this.getAuthorizationGenerators());
    }
}

