/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.directory.mavibot.btree.AbstractTransactionManager;
import org.apache.directory.mavibot.btree.BTreeHeader;

public class InMemoryTransactionManager
extends AbstractTransactionManager {
    private Lock transactionLock = new ReentrantLock();
    private static final ThreadLocal<Integer> context = new ThreadLocal();
    private Map<String, BTreeHeader<?, ?>> currentBTreeHeaders = new HashMap();
    private Map<String, BTreeHeader<?, ?>> newBTreeHeaders = new HashMap();
    private ReadWriteLock btreeHeadersLock = new ReentrantReadWriteLock();

    @Override
    public void beginTransaction() {
        this.transactionLock.lock();
        Integer nbTxnLevel = context.get();
        if (nbTxnLevel == null) {
            context.set(1);
        } else {
            context.set(nbTxnLevel + 1);
        }
    }

    @Override
    public void commit() {
        int nbTxnStarted = context.get();
        if (nbTxnStarted == 0) {
            this.transactionLock.unlock();
            return;
        }
        context.set(nbTxnStarted - 1);
        this.transactionLock.unlock();
    }

    @Override
    public void rollback() {
        context.set(0);
        this.transactionLock.unlock();
    }

    @Override
    public BTreeHeader getBTreeHeader(String name) {
        this.btreeHeadersLock.readLock().lock();
        BTreeHeader<?, ?> btreeHeader = this.currentBTreeHeaders.get(name);
        this.btreeHeadersLock.readLock().unlock();
        return btreeHeader;
    }

    @Override
    public void updateNewBTreeHeaders(BTreeHeader btreeHeader) {
        this.newBTreeHeaders.put(btreeHeader.getBtree().getName(), btreeHeader);
    }
}

