/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.extractors;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.regex.Pattern;
import org.pac4j.scribe.model.WeiboToken;

public class WeiboJsonExtractor
extends OAuth2AccessTokenJsonExtractor {
    public static final Pattern UID_REGEX = Pattern.compile("\"uid\"\\s*:\\s*\"(\\S*?)\"");

    public static WeiboJsonExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    protected OAuth2AccessToken createToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, String response) {
        OAuth2AccessToken token = super.createToken(accessToken, tokenType, expiresIn, refreshToken, scope, response);
        String uid = WeiboJsonExtractor.extractParameter((String)response, (Pattern)UID_REGEX, (boolean)true);
        if (uid == null || "".equals(uid)) {
            throw new OAuthException("There is no required UID in the response of the AssessToken endpoint.");
        }
        return new WeiboToken(token, uid);
    }

    private static class InstanceHolder {
        private static final WeiboJsonExtractor INSTANCE = new WeiboJsonExtractor();

        private InstanceHolder() {
        }
    }
}

