/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl.html;

import java.util.Collections;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptorFactory;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteFunctionProcessorFactory;
import org.apache.knox.gateway.filter.rewrite.impl.html.HtmlInfixDescriptor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;

public class HtmlInfixProcessor
implements UrlRewriteFunctionProcessor<HtmlInfixDescriptor> {
    private UrlRewriteFunctionProcessor frontend;

    @Override
    public void initialize(UrlRewriteEnvironment environment, HtmlInfixDescriptor descriptor) throws Exception {
        Object frontendDescriptor = UrlRewriteFunctionDescriptorFactory.create("frontend");
        this.frontend = UrlRewriteFunctionProcessorFactory.create("frontend", frontendDescriptor);
        this.frontend.initialize(environment, frontendDescriptor);
    }

    @Override
    public String name() {
        return "infix";
    }

    @Override
    public void destroy() throws Exception {
        this.frontend.destroy();
    }

    @Override
    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        String prefix = "";
        String postfix = "";
        if (parameters != null && parameters.size() > 1) {
            prefix = parameters.get(0);
            postfix = parameters.get(parameters.size() - 1);
            parameters = parameters.subList(1, parameters.size() - 1);
        }
        List<String> frontendValues = this.frontend.resolve(context, parameters);
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        if (frontendValues != null && !frontendValues.isEmpty()) {
            for (String value : frontendValues) {
                buffer.append(value);
            }
        }
        buffer.append(postfix);
        return Collections.singletonList(buffer.toString());
    }
}

