/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import java.util.Arrays;
import java.util.List;
import org.pac4j.core.authorization.checker.AuthorizationChecker;
import org.pac4j.core.authorization.checker.DefaultAuthorizationChecker;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.client.finder.ClientFinder;
import org.pac4j.core.client.finder.DefaultSecurityClientFinder;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.AbstractExceptionAwareLogic;
import org.pac4j.core.engine.SecurityGrantedAccessAdapter;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.engine.decision.DefaultProfileStorageDecision;
import org.pac4j.core.engine.decision.ProfileStorageDecision;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.http.ajax.DefaultAjaxRequestResolver;
import org.pac4j.core.matching.MatchingChecker;
import org.pac4j.core.matching.RequireAllMatchersChecker;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.util.CommonHelper;

public class DefaultSecurityLogic<R, C extends WebContext>
extends AbstractExceptionAwareLogic<R, C>
implements SecurityLogic<R, C> {
    private ClientFinder clientFinder = new DefaultSecurityClientFinder();
    private AuthorizationChecker authorizationChecker = new DefaultAuthorizationChecker();
    private MatchingChecker matchingChecker = new RequireAllMatchersChecker();
    private ProfileStorageDecision profileStorageDecision = new DefaultProfileStorageDecision();
    private AjaxRequestResolver ajaxRequestResolver = new DefaultAjaxRequestResolver();

    @Override
    public R perform(C context, Config config, SecurityGrantedAccessAdapter<R, C> securityGrantedAccessAdapter, HttpActionAdapter<R, C> httpActionAdapter, String clients, String authorizers, String matchers, Boolean inputMultiProfile, Object ... parameters) {
        HttpAction action;
        block11: {
            this.logger.debug("=== SECURITY ===");
            try {
                boolean multiProfile = inputMultiProfile == null ? false : inputMultiProfile;
                CommonHelper.assertNotNull("context", context);
                CommonHelper.assertNotNull("config", config);
                CommonHelper.assertNotNull("httpActionAdapter", httpActionAdapter);
                CommonHelper.assertNotNull("clientFinder", this.clientFinder);
                CommonHelper.assertNotNull("authorizationChecker", this.authorizationChecker);
                CommonHelper.assertNotNull("matchingChecker", this.matchingChecker);
                CommonHelper.assertNotNull("profileStorageDecision", this.profileStorageDecision);
                Clients configClients = config.getClients();
                CommonHelper.assertNotNull("configClients", configClients);
                this.logger.debug("url: {}", (Object)context.getFullRequestURL());
                this.logger.debug("matchers: {}", (Object)matchers);
                if (this.matchingChecker.matches((WebContext)context, matchers, config.getMatchers())) {
                    this.logger.debug("clients: {}", (Object)clients);
                    List<Client> currentClients = this.clientFinder.find(configClients, (WebContext)context, clients);
                    this.logger.debug("currentClients: {}", currentClients);
                    boolean loadProfilesFromSession = this.profileStorageDecision.mustLoadProfilesFromSession(context, currentClients);
                    this.logger.debug("loadProfilesFromSession: {}", (Object)loadProfilesFromSession);
                    ProfileManager manager = this.getProfileManager(context, config);
                    List<CommonProfile> profiles = manager.getAll(loadProfilesFromSession);
                    this.logger.debug("profiles: {}", profiles);
                    if (CommonHelper.isEmpty(profiles) && CommonHelper.isNotEmpty(currentClients)) {
                        boolean updated = false;
                        for (Client currentClient : currentClients) {
                            if (!(currentClient instanceof DirectClient)) continue;
                            this.logger.debug("Performing authentication for direct client: {}", (Object)currentClient);
                            Object credentials = currentClient.getCredentials((WebContext)context);
                            this.logger.debug("credentials: {}", credentials);
                            Object profile = currentClient.getUserProfile(credentials, (WebContext)context);
                            this.logger.debug("profile: {}", profile);
                            if (profile == null) continue;
                            boolean saveProfileInSession = this.profileStorageDecision.mustSaveProfileInSession(context, currentClients, (DirectClient)currentClient, (CommonProfile)profile);
                            this.logger.debug("saveProfileInSession: {} / multiProfile: {}", (Object)saveProfileInSession, (Object)multiProfile);
                            manager.save(saveProfileInSession, profile, multiProfile);
                            updated = true;
                            if (multiProfile) continue;
                            break;
                        }
                        if (updated) {
                            profiles = manager.getAll(loadProfilesFromSession);
                            this.logger.debug("new profiles: {}", profiles);
                        }
                    }
                    if (CommonHelper.isNotEmpty(profiles)) {
                        this.logger.debug("authorizers: {}", (Object)authorizers);
                        if (this.authorizationChecker.isAuthorized((WebContext)context, profiles, authorizers, config.getAuthorizers())) {
                            this.logger.debug("authenticated and authorized -> grant access");
                            return securityGrantedAccessAdapter.adapt(context, profiles, parameters);
                        }
                        this.logger.debug("forbidden");
                        action = this.forbidden(context, currentClients, profiles, authorizers);
                    } else if (this.startAuthentication(context, currentClients)) {
                        this.logger.debug("Starting authentication");
                        this.saveRequestedUrl(context, currentClients);
                        action = this.redirectToIdentityProvider(context, currentClients);
                    } else {
                        this.logger.debug("unauthorized");
                        action = this.unauthorized(context, currentClients);
                    }
                    break block11;
                }
                this.logger.debug("no matching for this request -> grant access");
                return securityGrantedAccessAdapter.adapt(context, Arrays.asList(new CommonProfile[0]), parameters);
            }
            catch (Exception e) {
                return this.handleException(e, httpActionAdapter, context);
            }
        }
        return httpActionAdapter.adapt(action.getCode(), context);
    }

    protected HttpAction forbidden(C context, List<Client> currentClients, List<CommonProfile> profiles, String authorizers) {
        return HttpAction.forbidden(context);
    }

    protected boolean startAuthentication(C context, List<Client> currentClients) {
        return CommonHelper.isNotEmpty(currentClients) && currentClients.get(0) instanceof IndirectClient;
    }

    protected void saveRequestedUrl(C context, List<Client> currentClients) {
        if (this.ajaxRequestResolver == null || !this.ajaxRequestResolver.isAjax((WebContext)context)) {
            String requestedUrl = context.getFullRequestURL();
            this.logger.debug("requestedUrl: {}", (Object)requestedUrl);
            context.getSessionStore().set(context, "pac4jRequestedUrl", requestedUrl);
        }
    }

    protected HttpAction redirectToIdentityProvider(C context, List<Client> currentClients) {
        IndirectClient currentClient = (IndirectClient)currentClients.get(0);
        return currentClient.redirect((WebContext)context);
    }

    protected HttpAction unauthorized(C context, List<Client> currentClients) {
        return HttpAction.unauthorized(context);
    }

    public ClientFinder getClientFinder() {
        return this.clientFinder;
    }

    public void setClientFinder(ClientFinder clientFinder) {
        this.clientFinder = clientFinder;
    }

    public AuthorizationChecker getAuthorizationChecker() {
        return this.authorizationChecker;
    }

    public void setAuthorizationChecker(AuthorizationChecker authorizationChecker) {
        this.authorizationChecker = authorizationChecker;
    }

    public MatchingChecker getMatchingChecker() {
        return this.matchingChecker;
    }

    public void setMatchingChecker(MatchingChecker matchingChecker) {
        this.matchingChecker = matchingChecker;
    }

    public ProfileStorageDecision getProfileStorageDecision() {
        return this.profileStorageDecision;
    }

    public void setProfileStorageDecision(ProfileStorageDecision profileStorageDecision) {
        this.profileStorageDecision = profileStorageDecision;
    }

    public AjaxRequestResolver getAjaxRequestResolver() {
        return this.ajaxRequestResolver;
    }

    public void setAjaxRequestResolver(AjaxRequestResolver ajaxRequestResolver) {
        this.ajaxRequestResolver = ajaxRequestResolver;
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "clientFinder", this.clientFinder, "authorizationChecker", this.authorizationChecker, "matchingChecker", this.matchingChecker, "profileStorageDecision", this.profileStorageDecision, "errorUrl", this.getErrorUrl(), "ajaxRequestResolver", this.ajaxRequestResolver);
    }
}

