/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.methodData.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.methodData.MethodDataContainer;
import org.apache.directory.shared.kerberos.codec.padata.PaDataContainer;
import org.apache.directory.shared.kerberos.components.PaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPaData
extends GrammarAction<MethodDataContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AddPaData.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddPaData() {
        super("Add a PA-DATA instance");
    }

    public void action(MethodDataContainer methodDataContainer) throws DecoderException {
        TLV tlv = methodDataContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_01308_ZERO_LENGTH_TLV, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_01309_EMPTY_TLV, (Object[])new Object[0]));
        }
        Asn1Decoder paDataDecoder = new Asn1Decoder();
        PaDataContainer paDataContainer = new PaDataContainer();
        paDataContainer.setStream(methodDataContainer.getStream());
        methodDataContainer.rewind();
        paDataDecoder.decode(methodDataContainer.getStream(), (Asn1Container)paDataContainer);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        methodDataContainer.updateParent();
        PaData paData = paDataContainer.getPaData();
        methodDataContainer.addPaData(paData);
        if (IS_DEBUG) {
            LOG.debug("PA-DATA added : {}", (Object)paData);
        }
        methodDataContainer.setGrammarEndAllowed(true);
    }
}

