/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import java.util.HashMap;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.KeyStoreCredentialResolver;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class KeyStoreCredentialProvider
implements CredentialProvider {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreCredentialProvider.class);
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private final CredentialResolver credentialResolver;
    private final String privateKey;

    public KeyStoreCredentialProvider(String keyStoreAlias, String keyStoreType, Resource keyStoreResource, String storePasswd, String privateKeyPasswd) {
        CommonHelper.assertNotNull((String)"keyStoreResource", (Object)keyStoreResource);
        CommonHelper.assertNotBlank((String)"storePasswd", (String)storePasswd);
        CommonHelper.assertNotBlank((String)"privateKeyPasswd", (String)privateKeyPasswd);
        InputStream inputStream = null;
        try {
            inputStream = keyStoreResource.getInputStream();
            KeyStore keyStore = this.loadKeyStore(inputStream, storePasswd, keyStoreType);
            this.privateKey = KeyStoreCredentialProvider.getPrivateKeyAlias(keyStore, keyStoreAlias);
            HashMap<String, String> passwords = new HashMap<String, String>();
            passwords.put(this.privateKey, privateKeyPasswd);
            this.credentialResolver = new KeyStoreCredentialResolver(keyStore, passwords);
        }
        catch (IOException e) {
            throw new SAMLException("Error loading keystore", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.debug("Error closing input stream of keystore", (Throwable)e);
                }
            }
        }
    }

    public KeyStoreCredentialProvider(SAML2Configuration configuration) {
        this(configuration.getKeyStoreAlias(), configuration.getKeyStoreType() == null ? DEFAULT_KEYSTORE_TYPE : configuration.getKeyStoreType(), configuration.getKeystoreResource(), configuration.getKeystorePassword(), configuration.getPrivateKeyPassword());
    }

    @Override
    public KeyInfo getKeyInfo() {
        Credential serverCredential = this.getCredential();
        KeyInfo keyInfo = this.generateKeyInfoForCredential(serverCredential);
        return keyInfo;
    }

    @Override
    public final CredentialResolver getCredentialResolver() {
        return this.credentialResolver;
    }

    @Override
    public KeyInfoCredentialResolver getKeyInfoCredentialResolver() {
        return DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver();
    }

    @Override
    public final KeyInfoGenerator getKeyInfoGenerator() {
        NamedKeyInfoGeneratorManager mgmr = DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager();
        Credential credential = this.getCredential();
        return mgmr.getDefaultManager().getFactory(credential).newInstance();
    }

    @Override
    public final Credential getCredential() {
        try {
            CriteriaSet cs = new CriteriaSet();
            EntityIdCriterion criteria = new EntityIdCriterion(this.privateKey);
            cs.add((Object)criteria);
            X509Credential creds = (X509Credential)this.credentialResolver.resolveSingle((Object)cs);
            return creds;
        }
        catch (ResolverException e) {
            throw new SAMLException("Can't obtain SP private key", e);
        }
    }

    protected final KeyInfo generateKeyInfoForCredential(Credential credential) {
        try {
            return this.getKeyInfoGenerator().generate(credential);
        }
        catch (SecurityException e) {
            throw new SAMLException("Unable to generate keyInfo from given credential", e);
        }
    }

    private KeyStore loadKeyStore(InputStream inputStream, String storePasswd, String keyStoreType) {
        try {
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            ks.load(inputStream, storePasswd == null ? null : storePasswd.toCharArray());
            return ks;
        }
        catch (Exception e) {
            throw new SAMLException("Error loading keystore", e);
        }
    }

    protected static String getPrivateKeyAlias(KeyStore keyStore, String keyStoreAlias) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String currentAlias = aliases.nextElement();
                if (!(keyStoreAlias != null ? currentAlias.equalsIgnoreCase(keyStoreAlias) : keyStore.entryInstanceOf(currentAlias, KeyStore.PrivateKeyEntry.class))) continue;
                return currentAlias;
            }
            throw new SAMLException("Keystore has no private keys");
        }
        catch (KeyStoreException e) {
            throw new SAMLException("Unable to get aliases from keyStore", e);
        }
    }
}

