/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal;

import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;
import org.glassfish.jersey.server.internal.process.MappableException;

@Priority(value=10)
@Singleton
public class MappableExceptionWrapperInterceptor
implements ReaderInterceptor,
WriterInterceptor {
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        try {
            return context.proceed();
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (MessageBodyProviderNotFoundException nfe) {
            throw nfe;
        }
        catch (MappableException mappable) {
            throw mappable;
        }
        catch (Exception e) {
            throw new MappableException(e);
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try {
            context.proceed();
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (MessageBodyProviderNotFoundException nfe) {
            throw nfe;
        }
        catch (MappableException mappable) {
            throw mappable;
        }
        catch (Exception e) {
            throw new MappableException(e);
        }
    }

    public static class Binder
    extends AbstractBinder {
        protected void configure() {
            this.bind(MappableExceptionWrapperInterceptor.class).to(ReaderInterceptor.class).to(WriterInterceptor.class).in(Singleton.class);
        }
    }
}

