/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.collection;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.ClassToInstanceMultiMap;

public class LockableClassToInstanceMultiMap<B>
extends ClassToInstanceMultiMap<B> {
    @Nonnull
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);

    public LockableClassToInstanceMultiMap() {
        this(false);
    }

    public LockableClassToInstanceMultiMap(boolean isIndexingSupertypes) {
        super(isIndexingSupertypes);
    }

    @Nonnull
    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public void clearWithLock() {
        Lock writeLock = this.getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            this.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKeyWithLock(@Nullable Class<?> key) {
        Lock readLock = this.getReadWriteLock().readLock();
        try {
            readLock.lock();
            boolean bl = this.containsKey(key);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValueWithLock(@Nonnull B value) {
        Lock readLock = this.getReadWriteLock().readLock();
        try {
            readLock.lock();
            boolean bl = this.containsValue(value);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @Live
    public <T> List<T> getWithLock(@Nullable Class<T> type) {
        Lock readLock = this.getReadWriteLock().readLock();
        try {
            readLock.lock();
            List<T> list = this.get(type);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public boolean isEmptyWithLock() {
        Lock readLock = this.getReadWriteLock().readLock();
        try {
            readLock.lock();
            boolean bl = this.isEmpty();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @Live
    public Set<Class<?>> keysWithLock() {
        Lock readLock = this.getReadWriteLock().readLock();
        try {
            readLock.lock();
            Set<Class<?>> set = this.keys();
            return set;
        }
        finally {
            readLock.unlock();
        }
    }

    public void putWithLock(@Nonnull B value) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            this.put(value);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void putAllWithLock(@Nullable @NonnullElements ClassToInstanceMultiMap<? extends B> map) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            this.putAll(map);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void putAllWithLock(@Nullable @NonnullElements Iterable<? extends B> newValues) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            this.putAll(newValues);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void removeWithLock(@Nonnull B value) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            this.remove(value);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void removeWithLock(@Nullable Class<?> type) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            this.remove(type);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void removeAllWithLock(@Nullable @NonnullElements ClassToInstanceMultiMap<? extends B> map) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            this.removeAll(map);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void removeAllWithLock(@Nullable @NonnullElements Iterable<? extends B> removeValues) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            this.removeAll(removeValues);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @Live
    public Collection<? extends B> valuesWithLock() {
        Lock readLock = this.getReadWriteLock().readLock();
        try {
            readLock.lock();
            Collection collection = this.values();
            return collection;
        }
        finally {
            readLock.unlock();
        }
    }
}

