/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.junit;

import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.junit.ArgMismatchFinder;
import org.mockito.internal.junit.MockitoTestListener;
import org.mockito.internal.junit.TestFinishedEvent;
import org.mockito.internal.util.MockitoLogger;
import org.mockito.mock.MockCreationSettings;

public class MismatchReportingTestListener
implements MockitoTestListener {
    private final MockitoLogger logger;
    private List<Object> mocks = new LinkedList<Object>();

    public MismatchReportingTestListener(MockitoLogger logger) {
        this.logger = logger;
    }

    @Override
    public void testFinished(TestFinishedEvent event) {
        List<Object> createdMocks = this.mocks;
        this.mocks = new LinkedList<Object>();
        String testName = event.getTestClassInstance().getClass().getSimpleName() + "." + event.getTestMethodName();
        if (event.getFailure() != null) {
            new ArgMismatchFinder().getStubbingArgMismatches(createdMocks).format(testName, this.logger);
        }
    }

    @Override
    public void onMockCreated(Object mock, MockCreationSettings settings) {
        this.mocks.add(mock);
    }
}

