/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiScheduleInterval;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Base class for commands that can be scheduled in Cloudera Manager. <p/> Note that schedule IDs are not preserved upon import. <p/>")
public class ApiSchedule {
    @SerializedName(value="id")
    private BigDecimal id = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="endTime")
    private String endTime = null;
    @SerializedName(value="interval")
    private BigDecimal interval = null;
    @SerializedName(value="intervalUnit")
    private ApiScheduleInterval intervalUnit = null;
    @SerializedName(value="nextRun")
    private String nextRun = null;
    @SerializedName(value="paused")
    private Boolean paused = null;
    @SerializedName(value="alertOnStart")
    private Boolean alertOnStart = null;
    @SerializedName(value="alertOnSuccess")
    private Boolean alertOnSuccess = null;
    @SerializedName(value="alertOnFail")
    private Boolean alertOnFail = null;
    @SerializedName(value="alertOnAbort")
    private Boolean alertOnAbort = null;

    public ApiSchedule id(BigDecimal id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The schedule id.")
    public BigDecimal getId() {
        return this.id;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    public ApiSchedule displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="The schedule display name.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiSchedule description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The schedule description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApiSchedule startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="The time at which the scheduled activity is triggered for the first time.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ApiSchedule endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The time after which the scheduled activity will no longer be triggered.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public ApiSchedule interval(BigDecimal interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(value="The duration between consecutive triggers of a scheduled activity.")
    public BigDecimal getInterval() {
        return this.interval;
    }

    public void setInterval(BigDecimal interval) {
        this.interval = interval;
    }

    public ApiSchedule intervalUnit(ApiScheduleInterval intervalUnit) {
        this.intervalUnit = intervalUnit;
        return this;
    }

    @ApiModelProperty(value="The unit for the repeat interval.")
    public ApiScheduleInterval getIntervalUnit() {
        return this.intervalUnit;
    }

    public void setIntervalUnit(ApiScheduleInterval intervalUnit) {
        this.intervalUnit = intervalUnit;
    }

    public ApiSchedule nextRun(String nextRun) {
        this.nextRun = nextRun;
        return this;
    }

    @ApiModelProperty(value="Readonly. The time the scheduled command will run next.")
    public String getNextRun() {
        return this.nextRun;
    }

    public void setNextRun(String nextRun) {
        this.nextRun = nextRun;
    }

    public ApiSchedule paused(Boolean paused) {
        this.paused = paused;
        return this;
    }

    @ApiModelProperty(value="The paused state for the schedule. The scheduled activity will not be triggered as long as the scheduled is paused.")
    public Boolean getPaused() {
        return this.paused;
    }

    public void setPaused(Boolean paused) {
        this.paused = paused;
    }

    public ApiSchedule alertOnStart(Boolean alertOnStart) {
        this.alertOnStart = alertOnStart;
        return this;
    }

    @ApiModelProperty(value="Whether to alert on start of the scheduled activity.")
    public Boolean getAlertOnStart() {
        return this.alertOnStart;
    }

    public void setAlertOnStart(Boolean alertOnStart) {
        this.alertOnStart = alertOnStart;
    }

    public ApiSchedule alertOnSuccess(Boolean alertOnSuccess) {
        this.alertOnSuccess = alertOnSuccess;
        return this;
    }

    @ApiModelProperty(value="Whether to alert on successful completion of the scheduled activity.")
    public Boolean getAlertOnSuccess() {
        return this.alertOnSuccess;
    }

    public void setAlertOnSuccess(Boolean alertOnSuccess) {
        this.alertOnSuccess = alertOnSuccess;
    }

    public ApiSchedule alertOnFail(Boolean alertOnFail) {
        this.alertOnFail = alertOnFail;
        return this;
    }

    @ApiModelProperty(value="Whether to alert on failure of the scheduled activity.")
    public Boolean getAlertOnFail() {
        return this.alertOnFail;
    }

    public void setAlertOnFail(Boolean alertOnFail) {
        this.alertOnFail = alertOnFail;
    }

    public ApiSchedule alertOnAbort(Boolean alertOnAbort) {
        this.alertOnAbort = alertOnAbort;
        return this;
    }

    @ApiModelProperty(value="Whether to alert on abort of the scheduled activity.")
    public Boolean getAlertOnAbort() {
        return this.alertOnAbort;
    }

    public void setAlertOnAbort(Boolean alertOnAbort) {
        this.alertOnAbort = alertOnAbort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiSchedule apiSchedule = (ApiSchedule)o;
        return Objects.equals(this.id, apiSchedule.id) && Objects.equals(this.displayName, apiSchedule.displayName) && Objects.equals(this.description, apiSchedule.description) && Objects.equals(this.startTime, apiSchedule.startTime) && Objects.equals(this.endTime, apiSchedule.endTime) && Objects.equals(this.interval, apiSchedule.interval) && Objects.equals((Object)this.intervalUnit, (Object)apiSchedule.intervalUnit) && Objects.equals(this.nextRun, apiSchedule.nextRun) && Objects.equals(this.paused, apiSchedule.paused) && Objects.equals(this.alertOnStart, apiSchedule.alertOnStart) && Objects.equals(this.alertOnSuccess, apiSchedule.alertOnSuccess) && Objects.equals(this.alertOnFail, apiSchedule.alertOnFail) && Objects.equals(this.alertOnAbort, apiSchedule.alertOnAbort);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.displayName, this.description, this.startTime, this.endTime, this.interval, this.intervalUnit, this.nextRun, this.paused, this.alertOnStart, this.alertOnSuccess, this.alertOnFail, this.alertOnAbort});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiSchedule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    intervalUnit: ").append(this.toIndentedString((Object)this.intervalUnit)).append("\n");
        sb.append("    nextRun: ").append(this.toIndentedString(this.nextRun)).append("\n");
        sb.append("    paused: ").append(this.toIndentedString(this.paused)).append("\n");
        sb.append("    alertOnStart: ").append(this.toIndentedString(this.alertOnStart)).append("\n");
        sb.append("    alertOnSuccess: ").append(this.toIndentedString(this.alertOnSuccess)).append("\n");
        sb.append("    alertOnFail: ").append(this.toIndentedString(this.alertOnFail)).append("\n");
        sb.append("    alertOnAbort: ").append(this.toIndentedString(this.alertOnAbort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

